/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler.monitor;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.threatIntel.action.monitor.IndexThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.IndexThreatIntelMonitorRequest;
import org.opensearch.securityanalytics.threatIntel.action.monitor.response.IndexThreatIntelMonitorResponse;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelMonitorDto;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class RestIndexThreatIntelMonitorAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestIndexThreatIntelMonitorAction.class);

    public String getName() {
        return "index_threat_intel_monitor_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/threat_intel/monitors"), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/threat_intel/monitors", "threat_intel_monitor_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ThreatIntelMonitorDto iocScanMonitor;
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/threat_intel/monitors"));
        String id = request.param("threat_intel_monitor_id", null);
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        try {
            iocScanMonitor = ThreatIntelMonitorDto.parse(xcp, id, null);
        }
        catch (Exception e) {
            log.error("Failed to parse threat intel monitor: ", (Throwable)e);
            throw new SecurityAnalyticsException("Failed to parse threat intel monitor: ", RestStatus.BAD_REQUEST, e);
        }
        IndexThreatIntelMonitorRequest indexThreatIntelMonitorRequest = new IndexThreatIntelMonitorRequest(id, request.method(), iocScanMonitor);
        return channel -> client.execute((ActionType)IndexThreatIntelMonitorAction.INSTANCE, (ActionRequest)indexThreatIntelMonitorRequest, this.getListener((RestChannel)channel, request.method()));
    }

    private RestResponseListener<IndexThreatIntelMonitorResponse> getListener(RestChannel channel, final RestRequest.Method restMethod) {
        return new RestResponseListener<IndexThreatIntelMonitorResponse>(channel){

            public RestResponse buildResponse(IndexThreatIntelMonitorResponse response) throws Exception {
                RestStatus returnStatus = RestStatus.CREATED;
                if (restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (restMethod == RestRequest.Method.POST) {
                    String location = String.format(Locale.getDefault(), "%s/%s", "/_plugins/_security_analytics/threat_intel/monitors", response.getId());
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

