/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.sink;

import java.io.IOException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.sink.AuditLogSink;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.threadpool.ThreadPool;

public abstract class AbstractInternalOpenSearchSink
extends AuditLogSink {
    protected final Client clientProvider;
    private final ThreadPool threadPool;
    private final DocWriteRequest.OpType storeOpType;

    public AbstractInternalOpenSearchSink(String name, Settings settings, String settingsPrefix, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink, DocWriteRequest.OpType storeOpType) {
        super(name, settings, settingsPrefix, fallbackSink);
        this.clientProvider = clientProvider;
        this.threadPool = threadPool;
        this.storeOpType = storeOpType;
    }

    @Override
    public void close() throws IOException {
    }

    public boolean doStore(AuditMessage msg, String indexName) {
        if (Boolean.parseBoolean(HeaderHelper.getSafeFromHeader(this.threadPool.getThreadContext(), "_opendistro_security_conf_request"))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("audit log of audit log will not be executed");
            }
            return true;
        }
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            IndexRequestBuilder irb = ((IndexRequestBuilder)this.clientProvider.prepareIndex(indexName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(msg.getAsMap());
            this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
            irb.setTimeout(TimeValue.timeValueMinutes((long)1L));
            if (this.storeOpType != null) {
                irb.setOpType(this.storeOpType);
            }
            irb.execute().actionGet();
            boolean bl = true;
            return bl;
        }
    }
}

