/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.master.ShardsAcknowledgedResponse;
import org.opensearch.common.Nullable;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class CloseIndexResponse
extends ShardsAcknowledgedResponse {
    private static final ConstructingObjectParser<CloseIndexResponse, Void> PARSER = new ConstructingObjectParser("close_index_response", true, args -> {
        boolean acknowledged = (Boolean)args[0];
        boolean shardsAcknowledged = args[1] != null ? (Boolean)args[1] : acknowledged;
        List indices = args[2] != null ? (List)args[2] : Collections.emptyList();
        return new CloseIndexResponse(acknowledged, shardsAcknowledged, indices);
    });
    private final List<IndexResult> indices;

    public CloseIndexResponse(boolean acknowledged, boolean shardsAcknowledged, List<IndexResult> indices) {
        super(acknowledged, shardsAcknowledged);
        this.indices = Collections.unmodifiableList(Objects.requireNonNull(indices));
    }

    public List<IndexResult> getIndices() {
        return this.indices;
    }

    public static CloseIndexResponse fromXContent(XContentParser parser) {
        return (CloseIndexResponse)((Object)PARSER.apply(parser, null));
    }

    static {
        CloseIndexResponse.declareAcknowledgedField(PARSER);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> parser.booleanValue(), SHARDS_ACKNOWLEDGED, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, name) -> IndexResult.fromXContent(p, name), new ParseField("indices", new String[0]));
    }

    public static class IndexResult {
        private static final ConstructingObjectParser<IndexResult, String> PARSER = new ConstructingObjectParser("index_result", true, (args, index) -> {
            ShardResult[] shardResults;
            Exception exception = (Exception)args[1];
            if (exception != null) {
                assert (!((Boolean)args[0]).booleanValue());
                return new IndexResult((String)index, exception);
            }
            ShardResult[] shardResultArray = shardResults = args[2] != null ? ((List)args[2]).toArray(new ShardResult[0]) : null;
            if (shardResults != null) {
                assert (!((Boolean)args[0]).booleanValue());
                return new IndexResult((String)index, shardResults);
            }
            assert (((Boolean)args[0]).booleanValue());
            return new IndexResult((String)index);
        });
        private final String index;
        @Nullable
        private final Exception exception;
        @Nullable
        private final ShardResult[] shards;

        IndexResult(String index) {
            this(index, null, null);
        }

        IndexResult(String index, Exception failure) {
            this(index, Objects.requireNonNull(failure), null);
        }

        IndexResult(String index, ShardResult[] shards) {
            this(index, null, Objects.requireNonNull(shards));
        }

        private IndexResult(String index, @Nullable Exception exception, @Nullable ShardResult[] shards) {
            this.index = Objects.requireNonNull(index);
            this.exception = exception;
            this.shards = shards;
        }

        public String getIndex() {
            return this.index;
        }

        @Nullable
        public Exception getException() {
            return this.exception;
        }

        @Nullable
        public ShardResult[] getShards() {
            return this.shards;
        }

        public boolean hasFailures() {
            if (this.exception != null) {
                return true;
            }
            if (this.shards != null) {
                for (ShardResult shard : this.shards) {
                    if (!shard.hasFailures()) continue;
                    return true;
                }
            }
            return false;
        }

        static IndexResult fromXContent(XContentParser parser, String name) {
            return (IndexResult)PARSER.apply(parser, (Object)name);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("closed", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)p.currentToken(), (XContentParser)p);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)p.nextToken(), (XContentParser)p);
                OpenSearchException e = OpenSearchException.failureFromXContent((XContentParser)p);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)p.nextToken(), (XContentParser)p);
                return e;
            }, new ParseField("exception", new String[0]));
            PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, id) -> ShardResult.fromXContent(p, id), new ParseField("failedShards", new String[0]));
        }
    }

    public static class ShardResult {
        private static final ConstructingObjectParser<ShardResult, String> PARSER = new ConstructingObjectParser("shard_result", true, (arg, id) -> {
            Failure[] failures = arg[0] != null ? ((List)arg[0]).toArray(new Failure[0]) : new Failure[]{};
            return new ShardResult(Integer.parseInt(id), failures);
        });
        private final int id;
        private final Failure[] failures;

        ShardResult(int id, Failure[] failures) {
            this.id = id;
            this.failures = failures;
        }

        public boolean hasFailures() {
            return this.failures != null && this.failures.length > 0;
        }

        public int getId() {
            return this.id;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        static ShardResult fromXContent(XContentParser parser, String id) {
            return (ShardResult)PARSER.apply(parser, (Object)id);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> (Failure)((Object)((Object)Failure.PARSER.apply(p, null))), new ParseField("failures", new String[0]));
        }

        public static class Failure
        extends DefaultShardOperationFailedException {
            static final ConstructingObjectParser<Failure, Void> PARSER = new ConstructingObjectParser("failure", true, arg -> new Failure((String)arg[0], (Integer)arg[1], (Throwable)arg[2], (String)arg[3]));
            @Nullable
            private String nodeId;

            Failure(String index, int shardId, Throwable reason, String nodeId) {
                super(index, shardId, reason);
                this.nodeId = nodeId;
            }

            public String getNodeId() {
                return this.nodeId;
            }

            static {
                Failure.declareFields(PARSER);
                PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("node", new String[0]));
            }
        }
    }
}

