/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.Version;
import org.opensearch.common.Explicit;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.OriginalMappingParameters;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.VectorValidator;

public class FlatVectorFieldMapper
extends KNNVectorFieldMapper {
    private final PerDimensionValidator perDimensionValidator;

    public static FlatVectorFieldMapper createFieldMapper(String fullname, String simpleName, Map<String, String> metaValue, KNNMethodConfigContext knnMethodConfigContext, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, OriginalMappingParameters originalMappingParameters, boolean isDerivedSourceEnabled) {
        KNNVectorFieldType mappedFieldType = new KNNVectorFieldType(fullname, metaValue, knnMethodConfigContext.getVectorDataType(), knnMethodConfigContext::getDimension);
        return new FlatVectorFieldMapper(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, knnMethodConfigContext.getVersionCreated(), originalMappingParameters, isDerivedSourceEnabled);
    }

    private FlatVectorFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, Version indexCreatedVersion, OriginalMappingParameters originalMappingParameters, boolean isDerivedSourceEnabled) {
        super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, indexCreatedVersion, originalMappingParameters, isDerivedSourceEnabled);
        this.useLuceneBasedVectorField = false;
        this.perDimensionValidator = this.selectPerDimensionValidator(this.vectorDataType);
        this.fieldType = new FieldType((IndexableFieldType)KNNVectorFieldMapper.Defaults.FIELD_TYPE);
        this.fieldType.setDocValuesType(DocValuesType.BINARY);
        if (isDerivedSourceEnabled) {
            this.fieldType.putAttribute("knn-derived-source-enabled", "true");
        }
        this.fieldType.freeze();
    }

    private PerDimensionValidator selectPerDimensionValidator(VectorDataType vectorDataType) {
        if (VectorDataType.BINARY == vectorDataType) {
            return PerDimensionValidator.DEFAULT_BIT_VALIDATOR;
        }
        if (VectorDataType.BYTE == vectorDataType) {
            return PerDimensionValidator.DEFAULT_BYTE_VALIDATOR;
        }
        return PerDimensionValidator.DEFAULT_FLOAT_VALIDATOR;
    }

    @Override
    protected VectorValidator getVectorValidator() {
        return VectorValidator.NOOP_VECTOR_VALIDATOR;
    }

    @Override
    protected PerDimensionValidator getPerDimensionValidator() {
        return this.perDimensionValidator;
    }

    @Override
    protected PerDimensionProcessor getPerDimensionProcessor() {
        return PerDimensionProcessor.NOOP_PROCESSOR;
    }
}

