/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store.index;

import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.CompiledLtrModel;
import com.o19s.es.ltr.feature.store.FeatureStore;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.ranker.parser.LtrRankerParserFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.BytesRef;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.Client;
import org.opensearch.client.Requests;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class IndexFeatureStore
implements FeatureStore {
    public static final int VERSION = 2;
    public static final Setting<Integer> STORE_VERSION_PROP = Setting.intSetting((String)"index.ltrstore_version", (int)2, (int)-1, (int)Integer.MAX_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    public static final String DEFAULT_STORE = ".ltrstore";
    public static final String STORE_PREFIX = ".ltrstore_";
    private static final String MAPPING_FILE = "fstore-index-mapping.json";
    private static final String ANALYSIS_FILE = "fstore-index-analysis.json";
    public static final Logger LOGGER = LogManager.getLogger(IndexFeatureStore.class);
    public static final String ES_TYPE = "store";
    private static final Pattern INVALID_NAMES = Pattern.compile("^(features?[*]?|feature_[sS]ets?|models?)$");
    private static final ObjectParser<ParserState, Void> SOURCE_PARSER = new ObjectParser("", true, () -> new ParserState());
    private final String index;
    private final Supplier<Client> clientSupplier;
    private final LtrRankerParserFactory parserFactory;

    public IndexFeatureStore(String index, Supplier<Client> clientSupplier, LtrRankerParserFactory factory) {
        this.index = Objects.requireNonNull(index);
        this.clientSupplier = Objects.requireNonNull(clientSupplier);
        this.parserFactory = Objects.requireNonNull(factory);
    }

    @Override
    public String getStoreName() {
        return this.index;
    }

    @Override
    public Feature load(String name) throws IOException {
        return this.getAndParse(name, StoredFeature.class, "feature").orElseThrow(() -> new ResourceNotFoundException("Unknown feature [" + name + "]", new Object[0])).optimize();
    }

    @Override
    public FeatureSet loadSet(String name) throws IOException {
        return this.getAndParse(name, StoredFeatureSet.class, "featureset").orElseThrow(() -> new ResourceNotFoundException("Unknown featureset [" + name + "]", new Object[0])).optimize();
    }

    public static String indexName(String storeName) {
        if (Objects.requireNonNull(storeName).isEmpty()) {
            throw new IllegalArgumentException("Store name cannot be empty");
        }
        return STORE_PREFIX + storeName;
    }

    public static String storeName(String indexName) {
        if (!IndexFeatureStore.isIndexStore(indexName)) {
            throw new IllegalArgumentException("[" + indexName + "] is not a valid index name for a feature store");
        }
        if (DEFAULT_STORE.equals(indexName)) {
            return "_default_";
        }
        assert (indexName.length() > STORE_PREFIX.length());
        return indexName.substring(STORE_PREFIX.length());
    }

    public static boolean isIndexStore(String indexName) {
        return Objects.requireNonNull(indexName).equals(DEFAULT_STORE) || indexName.startsWith(STORE_PREFIX) && indexName.length() > STORE_PREFIX.length();
    }

    @Override
    public CompiledLtrModel loadModel(String name) throws IOException {
        StoredLtrModel model = this.getAndParse(name, StoredLtrModel.class, "model").orElseThrow(() -> new ResourceNotFoundException("Unknown model [" + name + "]", new Object[0]));
        return model.compile(this.parserFactory);
    }

    public <E extends StorableElement> Optional<E> getAndParse(String name, Class<E> eltClass, String type) throws IOException {
        GetResponse response = this.internalGet(StorableElement.generateId(type, name)).get();
        if (response.isExists()) {
            return Optional.of(IndexFeatureStore.parse(eltClass, type, response.getSourceAsBytes()));
        }
        return Optional.empty();
    }

    public GetResponse getFeature(String name) {
        return this.internalGet(StorableElement.generateId("feature", name)).get();
    }

    public GetResponse getFeatureSet(String name) {
        return this.internalGet(StorableElement.generateId("featureset", name)).get();
    }

    public GetResponse getModel(String name) {
        return this.internalGet(StorableElement.generateId("model", name)).get();
    }

    private Supplier<GetResponse> internalGet(String id) {
        return () -> {
            Client client = this.clientSupplier.get();
            if (client.threadPool() == null) {
                return (GetResponse)client.prepareGet(this.index, id).get();
            }
            try (ThreadContext.StoredContext ignored = client.threadPool().getThreadContext().stashContext();){
                GetResponse getResponse = (GetResponse)client.prepareGet(this.index, id).get();
                return getResponse;
            }
        };
    }

    public static XContentBuilder toSource(StorableElement elt) throws IOException {
        XContentBuilder source = Requests.INDEX_CONTENT_TYPE.contentBuilder();
        source.startObject();
        source.field("name", elt.name());
        source.field("type", elt.type());
        source.field(elt.type(), (ToXContent)elt);
        source.endObject();
        return source;
    }

    public static <E extends StorableElement> E parse(Class<E> eltClass, String type, byte[] bytes) throws IOException {
        return IndexFeatureStore.parse(eltClass, type, bytes, 0, bytes.length);
    }

    public static <E extends StorableElement> E parse(Class<E> eltClass, String type, byte[] bytes, int offset, int length) throws IOException {
        try (XContentParser parser = MediaTypeRegistry.xContent((byte[])bytes).xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, bytes);){
            E e = IndexFeatureStore.parse(eltClass, type, parser);
            return e;
        }
    }

    public static <E extends StorableElement> E parse(Class<E> eltClass, String type, BytesReference bytesReference) throws IOException {
        BytesRef ref = bytesReference.toBytesRef();
        try (XContentParser parser = MediaTypeRegistry.xContent((byte[])ref.bytes, (int)ref.offset, (int)ref.length).xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, ref.bytes, ref.offset, ref.length);){
            E e = IndexFeatureStore.parse(eltClass, type, parser);
            return e;
        }
    }

    public static <E extends StorableElement> E parse(Class<E> eltClass, String type, XContentParser parser) throws IOException {
        StorableElement elt = ((ParserState)IndexFeatureStore.SOURCE_PARSER.parse((XContentParser)parser, null)).element;
        if (elt == null) {
            throw new IllegalArgumentException("No StorableElement found.");
        }
        if (!elt.type().equals(type)) {
            throw new IllegalArgumentException("Expected an element of type [" + type + "] but got [" + elt.type() + "].");
        }
        if (!eltClass.isAssignableFrom(elt.getClass())) {
            throw new RuntimeException("Cannot cast " + String.valueOf(elt.getClass()) + " to " + String.valueOf(eltClass) + " ( requested type [" + type + "])");
        }
        return (E)((StorableElement)eltClass.cast(elt));
    }

    public static CreateIndexRequest buildIndexRequest(String indexName) {
        return new CreateIndexRequest(indexName).mapping(IndexFeatureStore.readResourceFile(indexName, MAPPING_FILE), XContentType.JSON).settings(IndexFeatureStore.storeIndexSettings(indexName));
    }

    private static String readResourceFile(String indexName, String resource) {
        String string;
        block8: {
            InputStream is = IndexFeatureStore.class.getResourceAsStream(resource);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                is.transferTo(out);
                string = out.toString(StandardCharsets.UTF_8.name());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(() -> new ParameterizedMessage("failed to create ltr feature store index [{}] with resource [{}]", (Object)indexName, (Object)resource), (Throwable)e);
                    throw new IllegalStateException("failed to create ltr feature store index with resource [" + resource + "]", e);
                }
            }
            is.close();
        }
        return string;
    }

    private static Settings storeIndexSettings(String indexName) {
        return Settings.builder().put(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.getKey(), 1).put(IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING.getKey(), "0-2").put(STORE_VERSION_PROP.getKey(), 2).put("index.priority", Integer.MAX_VALUE).put("index.hidden", true).put(Settings.builder().loadFromSource(IndexFeatureStore.readResourceFile(indexName, ANALYSIS_FILE), (MediaType)XContentType.JSON).build()).build();
    }

    public static void validateFeatureStoreName(String storeName) {
        if (INVALID_NAMES.matcher(storeName).matches()) {
            throw new IllegalArgumentException("A featurestore name cannot be based on the words [feature], [featureset] and [model]");
        }
        MetadataCreateIndexService.validateIndexOrAliasName((String)storeName, (name, error) -> new IllegalArgumentException("Invalid feature store name [" + name + "]: " + error));
    }

    static {
        SOURCE_PARSER.declareField(ParserState::setElement, StoredFeature::parse, new ParseField("feature", new String[0]), ObjectParser.ValueType.OBJECT);
        SOURCE_PARSER.declareField(ParserState::setElement, StoredFeatureSet::parse, new ParseField("featureset", new String[0]), ObjectParser.ValueType.OBJECT);
        SOURCE_PARSER.declareField(ParserState::setElement, StoredLtrModel::parse, new ParseField("model", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    private static class ParserState {
        StorableElement element;

        private ParserState() {
        }

        void setElement(StorableElement element) {
            if (this.element != null) {
                throw new IllegalArgumentException("Element already set");
            }
            this.element = element;
        }
    }
}

