/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.termstat;

import com.o19s.es.explore.StatisticsHelper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.ClassicSimilarity;

public class TermStatSupplier
extends AbstractMap<String, ArrayList<Float>> {
    private final List<String> ACCEPTED_KEYS = Arrays.asList("df", "idf", "tf", "ttf", "tp");
    private StatisticsHelper.AggrType posAggrType = StatisticsHelper.AggrType.AVG;
    private final ClassicSimilarity sim = new ClassicSimilarity();
    private final StatisticsHelper df_stats = new StatisticsHelper();
    private final StatisticsHelper idf_stats = new StatisticsHelper();
    private final StatisticsHelper tf_stats = new StatisticsHelper();
    private final StatisticsHelper ttf_stats = new StatisticsHelper();
    private final StatisticsHelper tp_stats = new StatisticsHelper();
    private int matchedTermCount = 0;

    public void bump(IndexSearcher searcher, LeafReaderContext context, int docID, Set<Term> terms, ScoreMode scoreMode, Map<Term, TermStates> termContexts) throws IOException {
        this.df_stats.getData().clear();
        this.idf_stats.getData().clear();
        this.tf_stats.getData().clear();
        this.ttf_stats.getData().clear();
        this.tp_stats.getData().clear();
        this.matchedTermCount = 0;
        PostingsEnum postingsEnum = null;
        for (Term term : terms) {
            if (docID == Integer.MAX_VALUE) break;
            TermStates termStates = termContexts.get(term);
            assert (termStates != null && termStates.wasBuiltFor(ReaderUtil.getTopLevelContext((IndexReaderContext)context)));
            TermState state = termStates.get(context);
            if (state == null || termStates.docFreq() == 0) {
                this.insertZeroes();
                continue;
            }
            TermStatistics indexStats = searcher.termStatistics(term, termStates.docFreq(), termStates.totalTermFreq());
            this.df_stats.add(indexStats.docFreq());
            this.idf_stats.add(this.sim.idf(indexStats.docFreq(), searcher.collectionStatistics(term.field()).docCount()));
            this.ttf_stats.add(indexStats.totalTermFreq());
            TermsEnum termsEnum = context.reader().terms(term.field()).iterator();
            termsEnum.seekExact(term.bytes(), state);
            postingsEnum = termsEnum.postings(postingsEnum, 120);
            if (postingsEnum.advance(docID) == docID) {
                ++this.matchedTermCount;
                this.tf_stats.add(postingsEnum.freq());
                if (postingsEnum.freq() > 0) {
                    StatisticsHelper positions = new StatisticsHelper();
                    for (int i = 0; i < postingsEnum.freq(); ++i) {
                        positions.add((float)postingsEnum.nextPosition() + 1.0f);
                    }
                    this.tp_stats.add(positions.getAggr(this.posAggrType));
                    continue;
                }
                this.tp_stats.add(0.0f);
                continue;
            }
            this.tf_stats.add(0.0f);
            this.tp_stats.add(0.0f);
        }
    }

    @Override
    public boolean containsKey(Object statType) {
        return this.ACCEPTED_KEYS.contains(statType);
    }

    @Override
    public ArrayList<Float> get(Object statType) {
        String key;
        switch (key = (String)statType) {
            case "df": {
                return this.df_stats.getData();
            }
            case "idf": {
                return this.idf_stats.getData();
            }
            case "tf": {
                return this.tf_stats.getData();
            }
            case "ttf": {
                return this.ttf_stats.getData();
            }
            case "tp": {
                return this.tp_stats.getData();
            }
        }
        throw new IllegalArgumentException("Unsupported key requested: " + key);
    }

    @Override
    public Set<Map.Entry<String, ArrayList<Float>>> entrySet() {
        return new AbstractSet<Map.Entry<String, ArrayList<Float>>>(){

            @Override
            public Iterator<Map.Entry<String, ArrayList<Float>>> iterator() {
                return new Iterator<Map.Entry<String, ArrayList<Float>>>(){
                    private int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < TermStatSupplier.this.ACCEPTED_KEYS.size();
                    }

                    @Override
                    public Map.Entry<String, ArrayList<Float>> next() {
                        switch (this.index++) {
                            case 0: {
                                return new AbstractMap.SimpleImmutableEntry<String, ArrayList<Float>>("df", TermStatSupplier.this.df_stats.getData());
                            }
                            case 1: {
                                return new AbstractMap.SimpleImmutableEntry<String, ArrayList<Float>>("idf", TermStatSupplier.this.df_stats.getData());
                            }
                            case 2: {
                                return new AbstractMap.SimpleImmutableEntry<String, ArrayList<Float>>("tf", TermStatSupplier.this.df_stats.getData());
                            }
                            case 3: {
                                return new AbstractMap.SimpleImmutableEntry<String, ArrayList<Float>>("ttf", TermStatSupplier.this.df_stats.getData());
                            }
                            case 4: {
                                return new AbstractMap.SimpleImmutableEntry<String, ArrayList<Float>>("tp", TermStatSupplier.this.df_stats.getData());
                            }
                        }
                        return null;
                    }
                };
            }

            @Override
            public int size() {
                return TermStatSupplier.this.idf_stats.getData().size();
            }
        };
    }

    public int getMatchedTermCount() {
        return this.matchedTermCount;
    }

    public void setPosAggr(StatisticsHelper.AggrType type) {
        this.posAggrType = type;
    }

    private void insertZeroes() {
        this.df_stats.add(0.0f);
        this.idf_stats.add(0.0f);
        this.tf_stats.add(0.0f);
        this.ttf_stats.add(0.0f);
        this.tp_stats.add(0.0f);
    }
}

