/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Config;

public class ProfileUtil {
    private static SearchRequest createADRealtimeInittedEverRequest(String detectorId, long enabledTime, String resultIndex) {
        BoolQueryBuilder filterQuery = new BoolQueryBuilder();
        filterQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"detector_id", (String)detectorId));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"execution_end_time").gte((Object)enabledTime));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"anomaly_score").gt((Object)0));
        ExistsQueryBuilder taskIdExistsFilter = QueryBuilders.existsQuery((String)"task_id");
        filterQuery.mustNot((QueryBuilder)taskIdExistsFilter);
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)filterQuery).size(1);
        SearchRequest request = new SearchRequest(new String[]{".opendistro-anomaly-results"});
        request.source(source);
        if (resultIndex != null) {
            request.indices(new String[]{resultIndex});
        }
        return request;
    }

    private static SearchRequest createForecastRealtimeInittedEverRequest(String forecasterId, long enabledTime, String resultIndex) {
        BoolQueryBuilder filterQuery = new BoolQueryBuilder();
        filterQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"forecaster_id", (String)forecasterId));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"execution_end_time").gte((Object)enabledTime));
        ExistsQueryBuilder forecastsExistFilter = QueryBuilders.existsQuery((String)"forecast_value");
        filterQuery.must((QueryBuilder)forecastsExistFilter);
        ExistsQueryBuilder taskIdExistsFilter = QueryBuilders.existsQuery((String)"task_id");
        filterQuery.mustNot((QueryBuilder)taskIdExistsFilter);
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)filterQuery).size(1);
        SearchRequest request = new SearchRequest(new String[]{ForecastIndex.RESULT.getIndexName()});
        request.source(source);
        if (resultIndex != null) {
            request.indices(new String[]{resultIndex});
        }
        return request;
    }

    public static void confirmRealtimeInitStatus(Config config, long enabledTime, Client client, AnalysisType analysisType, ActionListener<SearchResponse> listener) {
        SearchRequest searchLatestResult = null;
        if (analysisType.isAD()) {
            searchLatestResult = ProfileUtil.createADRealtimeInittedEverRequest(config.getId(), enabledTime, config.getCustomResultIndexPattern());
        } else if (analysisType.isForecast()) {
            searchLatestResult = ProfileUtil.createForecastRealtimeInittedEverRequest(config.getId(), enabledTime, config.getCustomResultIndexPattern());
        } else {
            throw new IllegalArgumentException("Analysis type is not supported, type: : " + String.valueOf((Object)analysisType));
        }
        client.search(searchLatestResult, listener);
    }
}

