# frozen_string_literal: true

module CMSScanner
  # Generic Vulnerability
  class Vulnerability
    include References

    attr_reader :title, :type, :fixed_in, :introduced_in, :cvss

    # @param [ String ] title
    # @param [ Hash ] references
    # @option references [ Array<String>, String ] :cve
    # @option references [ Array<String>, String ] :secunia
    # @option references [ Array<String>, String ] :osvdb
    # @option references [ Array<String>, String ] :exploitdb
    # @option references [ Array<String> ] :url URL(s) to related advisories etc
    # @option references [ Array<String>, String ] :metasploit The related metasploit module(s)
    # @option references [ Array<String> ] :youtube
    # @param [ String ] type
    # @param [ String ] fixed_in
    # @param [ String ] introduced_in
    # @param [ HashSymbol ] cvss
    # @option cvss [ String ] :score
    # @option cvss [ String ] :vector
    def initialize(title, references: {}, type: nil, fixed_in: nil, introduced_in: nil, cvss: nil)
      @title         = title
      @type          = type
      @fixed_in      = fixed_in
      @introduced_in = introduced_in
      @cvss          = { score: cvss[:score], vector: cvss[:vector] } if cvss

      self.references = references
    end

    # param [ Vulnerability ] other
    #
    # @return [ Boolean ]
    def ==(other)
      title == other.title &&
        type == other.type &&
        references == other.references &&
        fixed_in == other.fixed_in &&
        cvss == other.cvss
    end
  end
end
