/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.JadxPluginManager;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.cli.JadxCLIArgs;
import jadx.core.utils.Utils;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class JCommanderWrapper<T> {
    private final JCommander jc;

    public JCommanderWrapper(T obj) {
        this.jc = JCommander.newBuilder().addObject(obj).build();
    }

    public boolean parse(String[] args) {
        try {
            this.jc.parse(args);
            return true;
        }
        catch (ParameterException e) {
            System.err.println("Arguments parse error: " + e.getMessage());
            this.printUsage();
            return false;
        }
    }

    public void overrideProvided(T obj) {
        List fieldsParams = this.jc.getParameters();
        ArrayList<ParameterDescription> parameters = new ArrayList<ParameterDescription>(1 + fieldsParams.size());
        parameters.add(this.jc.getMainParameterValue());
        parameters.addAll(fieldsParams);
        for (ParameterDescription parameter : parameters) {
            if (!parameter.isAssigned()) continue;
            Parameterized parameterized = parameter.getParameterized();
            Object providedValue = parameterized.get(parameter.getObject());
            Object newValue = JCommanderWrapper.mergeValues(parameterized.getType(), providedValue, () -> parameterized.get(obj));
            parameterized.set(obj, newValue);
        }
    }

    private static Object mergeValues(Class<?> type, Object value, Supplier<Object> prevValueProvider) {
        if (type.isAssignableFrom(Map.class)) {
            Map prevMap = (Map)prevValueProvider.get();
            return Utils.mergeMaps((Map)prevMap, (Map)((Map)value));
        }
        return value;
    }

    public void printUsage() {
        PrintStream out = System.out;
        out.println();
        out.println("jadx - dex to java decompiler, version: " + JadxDecompiler.getVersion());
        out.println();
        out.println("usage: jadx [options] " + this.jc.getMainParameterDescription());
        out.println("options:");
        List params = this.jc.getParameters();
        LinkedHashMap<String, ParameterDescription> paramsMap = new LinkedHashMap<String, ParameterDescription>(params.size());
        int maxNamesLen = 0;
        for (ParameterDescription p : params) {
            paramsMap.put(p.getParameterized().getName(), p);
            int len = p.getNames().length();
            if (len <= maxNamesLen) continue;
            maxNamesLen = len;
        }
        maxNamesLen += 3;
        JadxCLIArgs args = (JadxCLIArgs)this.jc.getObjects().get(0);
        for (Field f : this.getFields(args.getClass())) {
            String name = f.getName();
            ParameterDescription p = (ParameterDescription)paramsMap.get(name);
            if (p == null || p.getParameter().hidden()) continue;
            StringBuilder opt = new StringBuilder();
            opt.append("  ").append(p.getNames());
            String description = p.getDescription();
            JCommanderWrapper.addSpaces(opt, maxNamesLen - opt.length());
            if (description.contains("\n")) {
                String[] lines = description.split("\n");
                opt.append("- ").append(lines[0]);
                for (int i = 1; i < lines.length; ++i) {
                    opt.append('\n');
                    JCommanderWrapper.addSpaces(opt, maxNamesLen + 2);
                    opt.append(lines[i]);
                }
            } else {
                opt.append("- ").append(description);
            }
            String defaultValue = this.getDefaultValue(args, f, opt);
            if (defaultValue != null && !description.contains("(default)")) {
                opt.append(", default: ").append(defaultValue);
            }
            out.println(opt);
        }
        out.println(this.appendPluginOptions(maxNamesLen));
        out.println();
        out.println("Examples:");
        out.println("  jadx -d out classes.dex");
        out.println("  jadx --rename-flags \"none\" classes.dex");
        out.println("  jadx --rename-flags \"valid, printable\" classes.dex");
        out.println("  jadx --log-level ERROR app.apk");
        out.println("  jadx -Pdex-input.verify-checksum=no app.apk");
    }

    private List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    @Nullable
    private String getDefaultValue(JadxCLIArgs args, Field f, StringBuilder opt) {
        try {
            Enum val;
            Class<?> fieldType = f.getType();
            if (fieldType == Integer.TYPE) {
                return Integer.toString(f.getInt(args));
            }
            if (fieldType == String.class) {
                return (String)f.get(args);
            }
            if (Enum.class.isAssignableFrom(fieldType) && (val = (Enum)f.get(args)) != null) {
                return val.name().toLowerCase(Locale.ROOT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void addSpaces(StringBuilder str, int count) {
        for (int i = 0; i < count; ++i) {
            str.append(' ');
        }
    }

    private String appendPluginOptions(int maxNamesLen) {
        StringBuilder sb = new StringBuilder();
        JadxPluginManager pluginManager = new JadxPluginManager();
        pluginManager.load();
        int k = 1;
        for (JadxPlugin plugin : pluginManager.getAllPlugins()) {
            if (!(plugin instanceof JadxPluginOptions) || !this.appendPlugin((JadxPluginOptions)plugin, sb, maxNamesLen, k)) continue;
            ++k;
        }
        if (sb.length() == 0) {
            return "";
        }
        return "\nPlugin options (-P<name>=<value>):" + sb;
    }

    private boolean appendPlugin(JadxPluginOptions plugin, StringBuilder out, int maxNamesLen, int k) {
        List descs = plugin.getOptionsDescriptions();
        if (descs.isEmpty()) {
            return false;
        }
        JadxPluginInfo pluginInfo = plugin.getPluginInfo();
        out.append("\n ").append(k).append(") ");
        out.append(pluginInfo.getPluginId()).append(": ").append(pluginInfo.getDescription());
        for (OptionDescription desc : descs) {
            StringBuilder opt = new StringBuilder();
            opt.append("    - ").append(desc.name());
            JCommanderWrapper.addSpaces(opt, maxNamesLen - opt.length());
            opt.append("- ").append(desc.description());
            if (!desc.values().isEmpty()) {
                opt.append(", values: ").append(desc.values());
            }
            if (desc.defaultValue() != null) {
                opt.append(", default: ").append(desc.defaultValue());
            }
            out.append("\n").append((CharSequence)opt);
        }
        return true;
    }
}

