//
// TimerTask.h
//
// $Id: //poco/1.4/Util/include/Poco/Util/TimerTask.h#1 $
//
// Library: Util
// Package: Timer
// Module:  TimerTask
//
// Definition of the TimerTask class.
//
// Copyright (c) 2009, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Util_TimerTask_INCLUDED
#define Util_TimerTask_INCLUDED


#include "Poco/Util/Util.h"
#include "Poco/Runnable.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"
#include "Poco/Timestamp.h"


namespace Poco {
namespace Util {


class Util_API TimerTask: public Poco::RefCountedObject, public Poco::Runnable
	/// A task that can be scheduled for one-time or 
	/// repeated execution by a Timer.
	///
	/// This is an abstract class. Subclasses must override the run() member
	/// function to implement the actual task logic.
{
public:
	typedef Poco::AutoPtr<TimerTask> Ptr;
	
	TimerTask();
		/// Creates the TimerTask.
		
	void cancel();
		/// Cancels the execution of the timer.
		/// If the task has been scheduled for one-time execution and has 
		/// not yet run, or has not yet been scheduled, it will never run. 
		/// If the task has been scheduled for repeated execution, it will never 
		/// run again. If the task is running when this call occurs, the task 
		/// will run to completion, but will never run again.	
	
	bool isCancelled() const;
		/// Returns true iff the TimerTask has been cancelled by a call
		/// to cancel().
	
	Poco::Timestamp lastExecution() const;
		/// Returns the time of the last execution of the timer task.
		///
		/// Returns 0 if the timer has never been executed.
		
protected:
	~TimerTask();
		/// Destroys the TimerTask.
	
private:
	TimerTask(const TimerTask&);
	TimerTask& operator = (const TimerTask&);
	
	Poco::Timestamp _lastExecution;
	bool _isCancelled;
	
	friend class TaskNotification;
};


//
// inlines
//
inline bool TimerTask::isCancelled() const
{
	return _isCancelled;
}


inline Poco::Timestamp TimerTask::lastExecution() const
{
	return _lastExecution;
}


} } // namespace Poco::Util


#endif // Util_TimerTask_INCLUDED
