/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.BuildScopeModelBuilder;
import org.gradle.tooling.provider.model.internal.QueryToolingModelBuildOperationType;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

public class DefaultToolingModelBuilderRegistry
implements ToolingModelBuilderRegistry,
ToolingModelBuilderLookup {
    private final ToolingModelBuilderLookup parent;
    private final List<RegistrationImpl> registrations = new ArrayList<RegistrationImpl>();
    private final Collection<ToolingModelBuilder> builders = new AbstractCollection<ToolingModelBuilder>(){

        @Override
        public Iterator<ToolingModelBuilder> iterator() {
            return Iterators.transform(DefaultToolingModelBuilderRegistry.this.registrations.iterator(), RegistrationImpl::getBuilder);
        }

        @Override
        public int size() {
            return DefaultToolingModelBuilderRegistry.this.registrations.size();
        }
    };
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectStateRegistry projectStateRegistry;
    private final UserCodeApplicationContext userCodeApplicationContext;

    public DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, ProjectStateRegistry projectStateRegistry, UserCodeApplicationContext userCodeApplicationContext) {
        this(buildOperationExecutor, projectStateRegistry, null, userCodeApplicationContext);
        this.register(new VoidToolingModelBuilder());
    }

    private DefaultToolingModelBuilderRegistry(BuildOperationExecutor buildOperationExecutor, @Nullable ProjectStateRegistry projectStateRegistry, ToolingModelBuilderLookup parent, UserCodeApplicationContext userCodeApplicationContext) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.projectStateRegistry = projectStateRegistry;
        this.parent = parent;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }

    public DefaultToolingModelBuilderRegistry createChild() {
        return new DefaultToolingModelBuilderRegistry(this.buildOperationExecutor, this.projectStateRegistry, this, this.userCodeApplicationContext);
    }

    public void register(ToolingModelBuilder builder) {
        this.registrations.add(new RegistrationImpl(this.userCodeApplicationContext.current(), builder));
    }

    public ToolingModelBuilder getBuilder(String modelName) throws UnsupportedOperationException {
        ToolingModelBuilderLookup.Registration registration = this.get(modelName);
        return new LenientToolingModelBuilder(registration.getBuilder(), this.projectStateRegistry);
    }

    @Override
    public ToolingModelBuilderLookup.Builder locateForClientOperation(String modelName, boolean parameter, ProjectState target) throws UnknownModelException {
        return new BuildOperationWrappingBuilder(new LockSingleProjectBuilder(this.locateForClientOperation(modelName, target.getMutableModel(), parameter), target), modelName, target.getOwner(), target, target.getDisplayName(), this.buildOperationExecutor);
    }

    @Override
    @Nullable
    public ToolingModelBuilderLookup.Builder maybeLocateForBuildScope(String modelName, boolean parameter, BuildState target) {
        ToolingModelBuilderLookup.Registration registration = this.find(modelName);
        if (registration == null) {
            return null;
        }
        if (!(registration.getBuilder() instanceof BuildScopeModelBuilder)) {
            return null;
        }
        BuildScopeModelBuilder buildScopeModelBuilder = (BuildScopeModelBuilder)registration.getBuilder();
        return new BuildOperationWrappingBuilder(this.restoreUserCodeApplication(new BuildScopedBuilder(buildScopeModelBuilder, target), registration), modelName, target, null, target.getDisplayName(), this.buildOperationExecutor);
    }

    private ToolingModelBuilderLookup.Builder locateForClientOperation(String modelName, ProjectInternal project, boolean parameter) throws UnknownModelException {
        ToolingModelBuilderLookup.Registration registration = this.get(modelName);
        if (registration.getBuilder() instanceof ParameterizedToolingModelBuilder) {
            return this.restoreUserCodeApplication(new BuilderWithParameter(modelName, project, (ParameterizedToolingModelBuilder)registration.getBuilder()), registration);
        }
        if (parameter) {
            throw new UnknownModelException(String.format("No parameterized builders are available to build a model of type '%s'.", modelName));
        }
        return this.restoreUserCodeApplication(new BuilderWithNoParameter(modelName, project, registration.getBuilder()), registration);
    }

    private ToolingModelBuilderLookup.Builder restoreUserCodeApplication(ToolingModelBuilderLookup.Builder delegate, ToolingModelBuilderLookup.Registration registration) {
        UserCodeApplicationContext.Application registeredBy = registration.getRegisteredBy();
        if (registeredBy == null) {
            return delegate;
        }
        return new UserCodeAssigningBuilder(delegate, registeredBy);
    }

    @Override
    @Nullable
    public ToolingModelBuilderLookup.Registration find(String modelName) {
        RegistrationImpl match = null;
        for (RegistrationImpl registration : this.registrations) {
            if (!registration.builder.canBuild(modelName)) continue;
            if (match != null) {
                throw new UnsupportedOperationException(String.format("Multiple builders are available to build a model of type '%s'.", modelName));
            }
            match = registration;
        }
        if (match != null) {
            return match;
        }
        if (this.parent != null) {
            return this.parent.find(modelName);
        }
        return null;
    }

    private ToolingModelBuilderLookup.Registration get(String modelName) {
        ToolingModelBuilderLookup.Registration registration = this.find(modelName);
        if (registration != null) {
            return registration;
        }
        throw new UnknownModelException(String.format("No builders are available to build a model of type '%s'.", modelName));
    }

    private static class VoidToolingModelBuilder
    implements ToolingModelBuilder {
        private VoidToolingModelBuilder() {
        }

        public boolean canBuild(String modelName) {
            return modelName.equals(Void.class.getName());
        }

        public Object buildAll(String modelName, Project project) {
            return null;
        }
    }

    private static class UserCodeAssigningBuilder
    extends DelegatingBuilder {
        private final UserCodeApplicationContext.Application registeredBy;

        public UserCodeAssigningBuilder(ToolingModelBuilderLookup.Builder delegate, UserCodeApplicationContext.Application registeredBy) {
            super(delegate);
            this.registeredBy = registeredBy;
        }

        @Override
        public Object build(@Nullable Object parameter) {
            return this.registeredBy.reapply(() -> this.delegate.build(parameter));
        }
    }

    private static class BuildOperationWrappingBuilder
    extends DelegatingBuilder {
        private final String modelName;
        private final BuildState targetBuild;
        private final ProjectState targetProject;
        private final DisplayName targetDisplayName;
        private final BuildOperationExecutor buildOperationExecutor;

        private BuildOperationWrappingBuilder(ToolingModelBuilderLookup.Builder delegate, String modelName, BuildState targetBuild, @Nullable ProjectState targetProject, DisplayName targetDisplayName, BuildOperationExecutor buildOperationExecutor) {
            super(delegate);
            this.modelName = modelName;
            this.targetBuild = targetBuild;
            this.targetProject = targetProject;
            this.targetDisplayName = targetDisplayName;
            this.buildOperationExecutor = buildOperationExecutor;
        }

        @Override
        public Object build(final Object parameter) {
            return this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Object>(){

                public Object call(BuildOperationContext context) {
                    return delegate.build(parameter);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Build model '" + modelName + "' for " + targetDisplayName.getDisplayName())).progressDisplayName("Building model '" + modelName + "'").details((Object)new QueryToolingModelBuildOperationType.Details(){

                        @Override
                        public String getBuildPath() {
                            return targetBuild.getIdentityPath().getPath();
                        }

                        @Override
                        @Nullable
                        public String getProjectPath() {
                            if (targetProject != null) {
                                return targetProject.getProjectPath().getPath();
                            }
                            return null;
                        }
                    });
                }
            });
        }
    }

    private static class LockSingleProjectBuilder
    extends DelegatingBuilder {
        private final ProjectState target;

        public LockSingleProjectBuilder(ToolingModelBuilderLookup.Builder delegate, ProjectState target) {
            super(delegate);
            this.target = target;
        }

        @Override
        public Object build(Object parameter) {
            return this.target.fromMutableState(p -> this.delegate.build(parameter));
        }
    }

    private static class BuilderWithParameter
    implements ToolingModelBuilderLookup.Builder {
        private final String modelName;
        private final ProjectInternal project;
        private final ParameterizedToolingModelBuilder<?> delegate;

        public BuilderWithParameter(String modelName, ProjectInternal project, ParameterizedToolingModelBuilder<?> delegate) {
            this.modelName = modelName;
            this.project = project;
            this.delegate = delegate;
        }

        @Override
        public Class<?> getParameterType() {
            return this.delegate.getParameterType();
        }

        @Override
        public Object build(Object parameter) {
            if (parameter == null) {
                return this.delegate.buildAll(this.modelName, (Project)this.project);
            }
            return this.delegate.buildAll(this.modelName, Cast.uncheckedCast((Object)parameter), (Project)this.project);
        }
    }

    private static class BuilderWithNoParameter
    implements ToolingModelBuilderLookup.Builder {
        private final String modelName;
        private final ProjectInternal project;
        private final ToolingModelBuilder delegate;

        public BuilderWithNoParameter(String modelName, ProjectInternal project, ToolingModelBuilder delegate) {
            this.modelName = modelName;
            this.project = project;
            this.delegate = delegate;
        }

        public Class<Object> getParameterType() {
            return null;
        }

        @Override
        public Object build(Object parameter) {
            if (parameter != null) {
                throw new IllegalArgumentException("Expected a null parameter");
            }
            return this.delegate.buildAll(this.modelName, (Project)this.project);
        }
    }

    private static abstract class DelegatingBuilder
    implements ToolingModelBuilderLookup.Builder {
        final ToolingModelBuilderLookup.Builder delegate;

        public DelegatingBuilder(ToolingModelBuilderLookup.Builder delegate) {
            this.delegate = delegate;
        }

        @Override
        public Class<?> getParameterType() {
            return this.delegate.getParameterType();
        }
    }

    private static class LenientToolingModelBuilder
    implements ToolingModelBuilder {
        private final ToolingModelBuilder delegate;
        private final ProjectStateRegistry projectStateRegistry;

        public LenientToolingModelBuilder(ToolingModelBuilder delegate, ProjectStateRegistry projectStateRegistry) {
            this.delegate = delegate;
            this.projectStateRegistry = projectStateRegistry;
        }

        public boolean canBuild(String modelName) {
            return this.delegate.canBuild(modelName);
        }

        public Object buildAll(String modelName, Project project) {
            return this.projectStateRegistry.allowUncontrolledAccessToAnyProject(() -> this.delegate.buildAll(modelName, project));
        }
    }

    private static class BuildScopedBuilder
    implements ToolingModelBuilderLookup.Builder {
        private final BuildScopeModelBuilder buildScopeModelBuilder;
        private final BuildState target;

        public BuildScopedBuilder(BuildScopeModelBuilder buildScopeModelBuilder, BuildState target) {
            this.buildScopeModelBuilder = buildScopeModelBuilder;
            this.target = target;
        }

        @Override
        @Nullable
        public Class<?> getParameterType() {
            return null;
        }

        @Override
        public Object build(@Nullable Object parameter) {
            return this.buildScopeModelBuilder.create(this.target);
        }
    }

    private static class RegistrationImpl
    implements ToolingModelBuilderLookup.Registration {
        final UserCodeApplicationContext.Application registeredBy;
        final ToolingModelBuilder builder;

        public RegistrationImpl(UserCodeApplicationContext.Application registeredBy, ToolingModelBuilder builder) {
            this.registeredBy = registeredBy;
            this.builder = builder;
        }

        @Override
        public ToolingModelBuilder getBuilder() {
            return this.builder;
        }

        @Override
        public UserCodeApplicationContext.Application getRegisteredBy() {
            return this.registeredBy;
        }
    }
}

