/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.etable.TableColumnSelector;

class ColumnSelectionPanel
extends JPanel {
    private Map<ETableColumn, JCheckBox> checkBoxes = new HashMap<ETableColumn, JCheckBox>();
    private ETableColumnModel columnModel;

    public ColumnSelectionPanel(ETable eTable) {
        ETableColumnModel eTableColumnModel;
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        this.setLayout(new GridBagLayout());
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        this.columnModel = eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        arrayList.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        int n = arrayList.size() / 10 + 1;
        this.layoutPanel(arrayList, n, eTable);
    }

    private void layoutPanel(List list, int n, ETable eTable) {
        Object object;
        String string;
        ArrayList<Object> arrayList;
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ETableColumn eTableColumn : list) {
            JCheckBox jCheckBox = new JCheckBox();
            this.checkBoxes.put(eTableColumn, jCheckBox);
            String string2 = eTable.getColumnDisplayName(eTableColumn.getHeaderValue().toString());
            jCheckBox.setText(string2);
            jCheckBox.setSelected(!this.columnModel.isColumnHidden(eTableColumn));
            jCheckBox.setEnabled(eTableColumn.isHidingAllowed());
            if (!arrayList2.contains(string2)) {
                hashMap.put(string2, jCheckBox);
            } else {
                arrayList = null;
                string = hashMap.get(string2);
                if (string instanceof JCheckBox) {
                    object = (JCheckBox)((Object)string);
                    arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                } else if (string instanceof ArrayList) {
                    arrayList = (ArrayList)((Object)string);
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + string);
                }
                arrayList.add(jCheckBox);
                hashMap.put(string2, arrayList);
            }
            arrayList2.add(string2);
        }
        Collections.sort(arrayList2, Collator.getInstance());
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = list.size() / n;
        arrayList = arrayList2.iterator();
        while (arrayList.hasNext()) {
            Cloneable cloneable;
            if (n2 >= n5) {
                n2 = 0;
                ++n3;
            }
            string = (String)arrayList.next();
            object = hashMap.get(string);
            JCheckBox jCheckBox = null;
            if (object instanceof JCheckBox) {
                jCheckBox = (JCheckBox)object;
            } else if (object instanceof ArrayList) {
                cloneable = (ArrayList)object;
                if (n4 >= ((ArrayList)cloneable).size()) {
                    n4 = 0;
                }
                jCheckBox = (JCheckBox)((ArrayList)cloneable).get(n4++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + object);
            }
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).gridx = n3;
            ((GridBagConstraints)cloneable).gridy = n2++;
            ((GridBagConstraints)cloneable).insets = new Insets(5, 12, 0, 12);
            ((GridBagConstraints)cloneable).anchor = 18;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            this.add((Component)jCheckBox, cloneable);
        }
    }

    public void changeColumnVisibility() {
        if (this.columnModel == null) {
            return;
        }
        Iterator<ETableColumn> iterator = this.checkBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            ETableColumn eTableColumn;
            JCheckBox jCheckBox = this.checkBoxes.get(eTableColumn = iterator.next());
            this.columnModel.setColumnHidden(eTableColumn, !jCheckBox.isSelected());
        }
    }

    static void showColumnSelectionPopup(Component component, final ETable eTable) {
        ArrayList<Object> arrayList;
        Serializable serializable;
        String string;
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        if (!eTable.isPopupUsedFromTheCorner()) {
            ColumnSelectionPanel.showColumnSelectionDialog(eTable);
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        final ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList2 = Collections.list(eTableColumnModel.getColumns());
        arrayList2.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList2, ETableColumnComparator.DEFAULT);
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (final ETableColumn object : arrayList2) {
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            string = eTable.getColumnDisplayName(object.getHeaderValue().toString());
            jCheckBoxMenuItem.setText(string);
            jCheckBoxMenuItem.setSelected(!eTableColumnModel.isColumnHidden(object));
            jCheckBoxMenuItem.setEnabled(object.isHidingAllowed());
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    eTableColumnModel.setColumnHidden(object, !jCheckBoxMenuItem.isSelected());
                    eTable.updateColumnSelectionMouseListener();
                }
            });
            if (!arrayList3.contains(string)) {
                hashMap.put(string, jCheckBoxMenuItem);
            } else {
                serializable = null;
                arrayList = hashMap.get(string);
                if (arrayList instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)((Object)arrayList);
                    serializable = new ArrayList();
                    ((ArrayList)serializable).add(jCheckBoxMenuItem2);
                } else if (arrayList instanceof ArrayList) {
                    serializable = arrayList;
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + arrayList);
                }
                ((ArrayList)serializable).add(jCheckBoxMenuItem);
                hashMap.put(string, serializable);
            }
            arrayList3.add(string);
        }
        Collections.sort(arrayList3, Collator.getInstance());
        int n = 0;
        for (String string2 : arrayList3) {
            string = hashMap.get(string2);
            serializable = null;
            if (string instanceof JCheckBoxMenuItem) {
                serializable = (JCheckBoxMenuItem)((Object)string);
            } else if (string instanceof ArrayList) {
                arrayList = (ArrayList)((Object)string);
                if (n >= arrayList.size()) {
                    n = 0;
                }
                serializable = (JCheckBoxMenuItem)arrayList.get(n++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + string);
            }
            jPopupMenu.add((JMenuItem)serializable);
        }
        jPopupMenu.show(component, 8, 8);
    }

    static void showColumnSelectionDialog(ETable eTable) {
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        TableColumnSelector tableColumnSelector = eTable.getColumnSelector();
        if (tableColumnSelector != null) {
            ETableColumnModel eTableColumnModel = (ETableColumnModel)eTable.getColumnModel();
            TableColumnSelector.TreeNode treeNode = eTableColumnModel.getColumnHierarchyRoot();
            if (treeNode != null) {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray2 = tableColumnSelector.selectVisibleColumns(treeNode, stringArray);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray2);
            } else {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, false);
                String[] stringArray3 = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray4 = tableColumnSelector.selectVisibleColumns(stringArray, stringArray3);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray4);
            }
            return;
        }
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(eTable);
        int n = JOptionPane.showConfirmDialog(null, columnSelectionPanel, eTable.selectVisibleColumnsLabel, 2);
        if (n == 0) {
            columnSelectionPanel.changeColumnVisibility();
            eTable.updateColumnSelectionMouseListener();
        }
    }

    private static void makeVisibleColumns(ETable eTable, String[] stringArray) {
        ETableColumn eTableColumn;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        arrayList.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        HashMap<String, ETableColumn> hashMap = new HashMap<String, ETableColumn>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = eTable.getColumnDisplayName((eTableColumn = (ETableColumn)iterator.next()).getHeaderValue().toString());
            eTableColumnModel.setColumnHidden(eTableColumn, !hashSet.contains(string));
            hashMap.put(string, eTableColumn);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            eTableColumn = (ETableColumn)hashMap.get(stringArray[i]);
            if (eTableColumn == null) {
                throw new IllegalStateException("Cannot find column with name " + stringArray[i]);
            }
            int n = eTableColumnModel.getColumnIndex(eTableColumn.getIdentifier());
            eTableColumnModel.moveColumn(n, i);
        }
    }

    private static String[] getAvailableColumnNames(ETable eTable, boolean bl) {
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return new String[0];
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        if (!bl) {
            arrayList.addAll(eTableColumnModel.hiddenColumns);
        }
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ETableColumn eTableColumn : arrayList) {
            String string = eTable.getColumnDisplayName(eTableColumn.getHeaderValue().toString());
            arrayList2.add(string);
        }
        Collections.sort(arrayList2, Collator.getInstance());
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ETableColumnComparator
    implements Comparator<TableColumn> {
        public static final ETableColumnComparator DEFAULT = new ETableColumnComparator();

        private ETableColumnComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            if (tableColumn instanceof ETableColumn && tableColumn2 instanceof ETableColumn) {
                ((ETableColumn)tableColumn).compareTo((ETableColumn)tableColumn2);
            }
            return 0;
        }
    }
}

