/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.impl.gui.MouseOnlySortingStrategy;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import ca.odell.glazedlists.swt.EventTableViewer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public final class TableComparatorChooser
extends AbstractTableComparatorChooser {
    private final SortingStrategy sortingStrategy;
    private Table table;
    private List<Listener> sortListeners = new ArrayList<Listener>();
    private ColumnListener columnListener = new ColumnListener();

    public TableComparatorChooser(EventTableViewer eventTableViewer, SortedList sortedList, boolean multipleColumnSort) {
        super(sortedList, eventTableViewer.getTableFormat());
        this.table = eventTableViewer.getTable();
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumn(c).addSelectionListener((SelectionListener)this.columnListener);
        }
        this.sortingStrategy = new MouseOnlySortingStrategy(multipleColumnSort);
    }

    public void addSortListener(Listener sortListener) {
        this.sortListeners.add(sortListener);
    }

    public void removeSortActionListener(Listener sortListener) {
        Iterator<Listener> i = this.sortListeners.iterator();
        while (i.hasNext()) {
            if (sortListener != i.next()) continue;
            i.remove();
            return;
        }
        throw new IllegalArgumentException("Cannot remove nonexistent listener " + sortListener);
    }

    protected final void rebuildComparator() {
        super.rebuildComparator();
        Event sortEvent = new Event();
        sortEvent.widget = this.table;
        Iterator<Listener> i = this.sortListeners.iterator();
        while (i.hasNext()) {
            i.next().handleEvent(sortEvent);
        }
    }

    public void dispose() {
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumn(c).removeSelectionListener((SelectionListener)this.columnListener);
        }
    }

    class ColumnListener
    implements SelectionListener {
        ColumnListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            Table table = column.getParent();
            int columnIndex = table.indexOf(column);
            TableComparatorChooser.this.sortingStrategy.columnClicked(TableComparatorChooser.this.sortingState, columnIndex, 1, false, false);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

