/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public class CommandEvent
extends EventObject {
    private final Integer m_procId;
    private final Integer m_cmdId;
    private final String m_cmdName;
    private final List m_args;

    public CommandEvent(Integer procId, Integer cmdId, String cmdName, List args) {
        super(cmdName);
        this.m_procId = procId;
        this.m_cmdId = cmdId;
        this.m_cmdName = cmdName;
        this.m_args = new ArrayList(args);
    }

    public Integer getProcId() {
        return this.m_procId;
    }

    public Integer getCmdId() {
        return this.m_cmdId;
    }

    public String getCmdName() {
        return this.m_cmdName;
    }

    public List getArgs() {
        return this.m_args;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CommandEvent)) {
            return false;
        }
        CommandEvent event = (CommandEvent)other;
        return this.getProcId().equals(event.getProcId());
    }

    public int hashCode() {
        return this.getProcId().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[" + "m_procId=" + this.m_procId + "," + "m_cmdId=" + this.m_cmdId + "," + "m_cmdName=" + this.m_cmdName + "," + "m_args=" + this.m_args + "]";
    }
}

