/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class AuthenticationAPI
extends ApiImplementor {
    private static final Logger log = LogManager.getLogger(AuthenticationAPI.class);
    private static final String PREFIX = "authentication";
    private static final String VIEW_GET_AUTHENTICATION = "getAuthenticationMethod";
    private static final String VIEW_GET_LOGGED_IN_INDICATOR = "getLoggedInIndicator";
    private static final String VIEW_GET_LOGGED_OUT_INDICATOR = "getLoggedOutIndicator";
    private static final String VIEW_GET_METHOD_CONFIG_PARAMETERS = "getAuthenticationMethodConfigParams";
    private static final String VIEW_GET_SUPPORTED_METHODS = "getSupportedAuthenticationMethods";
    private static final String ACTION_SET_LOGGED_IN_INDICATOR = "setLoggedInIndicator";
    private static final String ACTION_SET_LOGGED_OUT_INDICATOR = "setLoggedOutIndicator";
    private static final String ACTION_SET_METHOD = "setAuthenticationMethod";
    public static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_LOGGED_IN_INDICATOR = "loggedInIndicatorRegex";
    private static final String PARAM_LOGGED_OUT_INDICATOR = "loggedOutIndicatorRegex";
    private static final String PARAM_METHOD_NAME = "authMethodName";
    private static final String PARAM_METHOD_CONFIG_PARAMS = "authMethodConfigParams";
    private Map<String, AuthMethodEntry> loadedAuthenticationMethodActions;

    public AuthenticationAPI(ExtensionAuthentication extension) {
        this.addApiView(new ApiView(VIEW_GET_SUPPORTED_METHODS));
        this.addApiView(new ApiView(VIEW_GET_METHOD_CONFIG_PARAMETERS, new String[]{PARAM_METHOD_NAME}));
        this.addApiView(new ApiView(VIEW_GET_AUTHENTICATION, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_LOGGED_IN_INDICATOR, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_LOGGED_OUT_INDICATOR, new String[]{PARAM_CONTEXT_ID}));
        this.loadedAuthenticationMethodActions = new HashMap<String, AuthMethodEntry>();
        if (extension != null) {
            for (AuthenticationMethodType t : extension.getAuthenticationMethodTypes()) {
                ApiDynamicActionImplementor i = t.getSetMethodForContextApiAction();
                if (i == null) continue;
                this.loadedAuthenticationMethodActions.put(i.getName(), new AuthMethodEntry(t, i));
            }
        }
        this.addApiAction(new ApiAction(ACTION_SET_METHOD, new String[]{PARAM_CONTEXT_ID, PARAM_METHOD_NAME}, new String[]{PARAM_METHOD_CONFIG_PARAMS}));
        this.addApiAction(new ApiAction(ACTION_SET_LOGGED_IN_INDICATOR, new String[]{PARAM_CONTEXT_ID, PARAM_LOGGED_IN_INDICATOR}));
        this.addApiAction(new ApiAction(ACTION_SET_LOGGED_OUT_INDICATOR, new String[]{PARAM_CONTEXT_ID, PARAM_LOGGED_OUT_INDICATOR}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        log.debug("handleApiView " + name + " " + params.toString());
        switch (name) {
            case "getAuthenticationMethod": {
                return this.getContext(params).getAuthenticationMethod().getApiResponseRepresentation();
            }
            case "getLoggedInIndicator": {
                Pattern loggedInPattern = this.getContext(params).getAuthenticationMethod().getLoggedInIndicatorPattern();
                if (loggedInPattern != null) {
                    return new ApiResponseElement("logged_in_regex", loggedInPattern.toString());
                }
                return new ApiResponseElement("logged_in_regex", "");
            }
            case "getLoggedOutIndicator": {
                Pattern loggedOutPattern = this.getContext(params).getAuthenticationMethod().getLoggedOutIndicatorPattern();
                if (loggedOutPattern != null) {
                    return new ApiResponseElement("logged_out_regex", loggedOutPattern.toString());
                }
                return new ApiResponseElement("logged_out_regex", "");
            }
            case "getSupportedAuthenticationMethods": {
                ApiResponseList supportedMethods = new ApiResponseList("supportedMethods");
                for (AuthMethodEntry entry : this.loadedAuthenticationMethodActions.values()) {
                    supportedMethods.addItem(new ApiResponseElement("methodName", entry.getApi().getName()));
                }
                return supportedMethods;
            }
            case "getAuthenticationMethodConfigParams": {
                ApiDynamicActionImplementor a = this.getSetMethodActionImplementor(params).getApi();
                return a.buildParamsDescription();
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug("handleApiAction " + name + " " + params.toString());
        switch (name) {
            case "setLoggedInIndicator": {
                String loggedInIndicator = params.getString(PARAM_LOGGED_IN_INDICATOR);
                if (loggedInIndicator == null || loggedInIndicator.isEmpty()) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_LOGGED_IN_INDICATOR);
                }
                Context context = this.getContext(params);
                context.getAuthenticationMethod().setLoggedInIndicatorPattern(loggedInIndicator);
                context.save();
                return ApiResponseElement.OK;
            }
            case "setLoggedOutIndicator": {
                String loggedOutIndicator = params.getString(PARAM_LOGGED_OUT_INDICATOR);
                if (loggedOutIndicator == null || loggedOutIndicator.isEmpty()) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_LOGGED_OUT_INDICATOR);
                }
                Context context = this.getContext(params);
                context.getAuthenticationMethod().setLoggedOutIndicatorPattern(loggedOutIndicator);
                context.save();
                return ApiResponseElement.OK;
            }
            case "setAuthenticationMethod": {
                JSONObject actionParams = params.has(PARAM_METHOD_CONFIG_PARAMS) ? API.getParams(params.getString(PARAM_METHOD_CONFIG_PARAMS)) : new JSONObject();
                Context context = this.getContext(params);
                actionParams.put(PARAM_CONTEXT_ID, (Object)context.getId());
                AuthenticationMethodType oldMethodType = context.getAuthenticationMethod().getType();
                AuthMethodEntry authEntry = this.getSetMethodActionImplementor(params);
                authEntry.getApi().handleAction(actionParams);
                AuthenticationAPI.resetUsersCredentials(context.getId(), oldMethodType, authEntry.getMethodType());
                context.save();
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private static void resetUsersCredentials(int contextId, AuthenticationMethodType oldMethod, AuthenticationMethodType newMethod) {
        ExtensionUserManagement usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
        if (usersExtension == null || oldMethod.getAuthenticationCredentialsType() == newMethod.getAuthenticationCredentialsType()) {
            return;
        }
        List<User> users = usersExtension.getContextUserAuthManager(contextId).getUsers();
        users.forEach(user -> {
            user.setEnabled(false);
            user.setAuthenticationCredentials(newMethod.createAuthenticationCredentials());
        });
    }

    private AuthMethodEntry getSetMethodActionImplementor(JSONObject params) throws ApiException {
        AuthMethodEntry a = this.loadedAuthenticationMethodActions.get(ApiUtils.getNonEmptyStringParam(params, PARAM_METHOD_NAME));
        if (a == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, "No authentication method type matches the provided value.");
        }
        return a;
    }

    private Context getContext(JSONObject params) throws ApiException {
        return ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
    }

    private static class AuthMethodEntry {
        private final AuthenticationMethodType methodType;
        private final ApiDynamicActionImplementor api;

        public AuthMethodEntry(AuthenticationMethodType methodType, ApiDynamicActionImplementor api) {
            this.methodType = methodType;
            this.api = api;
        }

        public AuthenticationMethodType getMethodType() {
            return this.methodType;
        }

        public ApiDynamicActionImplementor getApi() {
            return this.api;
        }
    }
}

