%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/two--partcombine-pairs-on-one-staff.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
@code{\\partCombine} 関数は 2 パートの音楽表記を取り、@c
パートがどのように結合されるかに応じて、@qq{two}, @qq{one},
@qq{solo}, @qq{chords} の 4 つの @code{Voice} に配置します。@c
@code{\\partCombine} によって出力されたボイスは、それぞれがレイアウト
プロパティを持ち、通常の方法で調整することができます。@c
ここでは、@code{\\partCombine} を拡張し、4 つのボイスを 1 つの譜を結合する@c
作業を簡単にしています。

soprano = @{ d'4 | cis'  b  e'  d'8 cis' | cis'2 b @} alto = @{ fis4 |
e8 fis gis ais b4 b | b ais fis2 @} tenor = @{ a8 b | cis' dis' e'4 b8
cis' d'4 | gis cis' dis'2 @} bass = @{ fis8 gis | a4 gis g fis | eis
fis b,2 @}

\\new Staff <<
  \\key b\\minor
  \\clef alto
  \\partial 4
  \\transpose b b'
  \\partCombineUp \\soprano \\alto
  \\partCombineDown \\tenor \\bass >>

"
  doctitleja = "1 つの譜で 2 つの \\partCombine を使用する"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
La fonction @code{\\partCombine} prend deux expressions musicales
contenant chacune une partie et les distribue dans quatre contextes
@code{Voice} nommés « two », « one », « solo » et « chords » selon le
moment et la manière dont ces parties fusionnent en une voix commune.
Les voix issues de @code{\\partCombine} peuvent disposer de leurs
propres propriétés de mise en forme définies de manière habituelle. Sont
ici définies des extensions à @code{\\partCombine} de sorte à faciliter
le placement de quatre voix sur une seule portée.

@verbatim
soprano = { d'4 | cis'  b  e'  d'8 cis' | cis'2 b }
alto = { fis4 | e8 fis gis ais b4 b | b ais fis2 }
tenor = { a8 b | cis' dis' e'4 b8 cis' d'4 | gis cis' dis'2 }
bass = { fis8 gis | a4 gis g fis | eis fis b,2 }

\\new Staff <<
  \\key b\\minor
  \\clef alto
  \\partial 4
  \\transpose b b'
  \\partCombineUp \\soprano \\alto
  \\partCombineDown \\tenor \\bass
>>
@end verbatim
"

  doctitlefr = "Deux @code{\\partCombine} sur une même portée"

  lsrtags = "simultaneous-notes, staff-notation"

  texidoc = "
The @code{\\partCombine} function takes two music expressions each
containing a part, and distributes them among four @code{Voice}s named
@qq{two}, @qq{one}, @qq{solo}, and @qq{chords} depending on when and how
the parts are merged into a common voice.  The voices output from
@code{\\partCombine} can have their layout properties adjusted in the
usual way.  Here we define extensions of @code{\\partCombine} to make
it easier to put four voices on a staff.

@verbatim
soprano = { d'4 | cis'  b  e'  d'8 cis' | cis'2 b }
alto = { fis4 | e8 fis gis ais b4 b | b ais fis2 }
tenor = { a8 b | cis' dis' e'4 b8 cis' d'4 | gis cis' dis'2 }
bass = { fis8 gis | a4 gis g fis | eis fis b,2 }

\\new Staff <<
  \\key b\\minor
  \\clef alto
  \\partial 4
  \\transpose b b'
  \\partCombineUp \\soprano \\alto
  \\partCombineDown \\tenor \\bass
>>
@end verbatim
"

  doctitle = "Two \\partCombine pairs on one staff"
} % begin verbatim


\layout {
  \context {
    \Staff
    \accepts "VoiceBox"
  }
  \context {
    \name "VoiceBox"
    \type "Engraver_group"
    \defaultchild "Voice"
    \accepts "Voice"
    \accepts "NullVoice"
  }
}

customPartCombineUp =
#(define-music-function (partOne partTwo)
  (ly:music? ly:music?)
"Take the music in @var{partOne} and @var{partTwo} and return
a @code{VoiceBox} named @q{Up} containing @code{Voice}s
that contain @var{partOne} and @var{partTwo} merged into one
voice where feasible.  This variant sets the default voicing
in the output to use upward stems."
#{
  \new VoiceBox = "Up" <<
    \context Voice = "one" { \voiceOne }
    \context Voice = "two" { \voiceThree }
    \context Voice = "shared" { \voiceOne }
    \context Voice = "solo" { \voiceOne }
    \context NullVoice = "null" {}
    \partCombine #partOne #partTwo
  >>
#})

customPartCombineDown = #
(define-music-function (partOne partTwo)
  (ly:music? ly:music?)
"Take the music in @var{partOne} and @var{partTwo} and return
a @code{VoiceBox} named @q{Down} containing @code{Voice}s
that contain @var{partOne} and @var{partTwo} merged into one
voice where feasible.  This variant sets the default voicing
in the output to use downward stems."
#{
  \new VoiceBox = "Down" <<
    \set VoiceBox.soloText = #"Solo III"
    \set VoiceBox.soloIIText = #"Solo IV"
    \context Voice ="one" { \voiceFour }
    \context Voice ="two" { \voiceTwo }
    \context Voice ="shared" { \voiceFour }
    \context Voice ="solo" { \voiceFour }
    \context NullVoice = "null" {}
    \partCombine #partOne #partTwo
  >>
#})

soprano = { d'4 | cis'  b  e'  d'8 cis' | cis'2 b }
alto = { fis4 | e8 fis gis ais b4 b | b ais fis2 }
tenor = { a8 b | cis' dis' e'4 b8 cis' d'4 | gis cis' dis'2 }
bass = { fis8 gis | a4 gis g fis | eis fis b,2 }

\new Staff <<
  \key b\minor
  \clef alto
  \partial 4
  \transpose b b'
  \customPartCombineUp \soprano \alto
  \customPartCombineDown \tenor \bass
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
