/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.jar.JarFileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.PDIClassLoader;
import org.pentaho.di.core.annotations.Job;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.config.ConfigManager;
import org.pentaho.di.core.config.KettleConfig;
import org.pentaho.di.core.exception.KettleConfigException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginLocation;
import org.pentaho.di.core.util.ResolverUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobPlugin;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.trans.StepPlugin;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static final String WORK_DIR = "work";
    public static final String DEFAULT_LIB = "lib/*.jar";
    private static final String JAR = "jar";
    private static final LogWriter log = LogWriter.getInstance();
    private final Set<PluginLocation> locs;
    private final Map<Class<? extends Annotation>, Set<? extends Plugin>> plugins;
    private final Map<Class<? extends Annotation>, ResolverUtil.Test> tests = new HashMap<Class<? extends Annotation>, ResolverUtil.Test>();
    private static PluginLoader loader = new PluginLoader();

    private PluginLoader() {
        this.tests.put(Job.class, (ResolverUtil.Test)new ResolverUtil.AnnotatedWith(Job.class));
        this.tests.put(Step.class, (ResolverUtil.Test)new ResolverUtil.AnnotatedWith(Step.class));
        this.locs = new HashSet<PluginLocation>();
        this.plugins = new HashMap<Class<? extends Annotation>, Set<? extends Plugin>>();
        this.plugins.put(Job.class, new HashSet());
        this.plugins.put(Step.class, new HashSet());
    }

    public static PluginLoader getInstance() {
        return loader;
    }

    public void load(String mgr) throws KettleConfigException {
        ConfigManager<?> c = KettleConfig.getInstance().getManager(mgr);
        this.locs.addAll(c.loadAs(PluginLocation.class));
        this.doConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConfig() throws KettleConfigException {
        Set<PluginLocation> set = this.locs;
        synchronized (set) {
            String sjar = ".jar";
            for (PluginLocation plugin : this.locs) {
                File base = new File(System.getProperty("user.dir"));
                try {
                    FileSystemManager mgr = VFS.getManager();
                    FileObject fobj = mgr.resolveFile(base, plugin.getLocation());
                    if (fobj.isReadable()) {
                        int nlen;
                        String name = fobj.getName().getURI();
                        int jindex = name.indexOf(sjar);
                        boolean isJar = jindex == (nlen = name.length()) - 4 || jindex == nlen - 6;
                        try {
                            if (isJar) {
                                this.build(fobj, true);
                                continue;
                            }
                            for (FileObject childFolder : fobj.getChildren()) {
                                boolean isAlsoJar = childFolder.getName().getURI().endsWith(sjar);
                                if (!isAlsoJar && childFolder.getType() != FileType.FOLDER || childFolder.getName().getBaseName().equalsIgnoreCase(".svn") || childFolder.getName().getBaseName().equalsIgnoreCase(".cvs")) continue;
                                try {
                                    this.build(childFolder, isAlsoJar);
                                }
                                catch (KettleConfigException e) {
                                    log.logError("PluginLoader", e.getMessage(), new Object[0]);
                                }
                            }
                            continue;
                        }
                        catch (FileSystemException e) {
                            log.logError("PluginLoader", e.getMessage(), new Object[0]);
                            continue;
                        }
                        catch (KettleConfigException e) {
                            log.logError("PluginLoader", e.getMessage(), new Object[0]);
                            continue;
                        }
                    }
                    log.logDebug("PluginLoader", fobj + " does not exist, ignoring this.", new Object[0]);
                }
                catch (Exception e) {
                    throw new KettleConfigException((Throwable)e);
                }
            }
        }
    }

    public <E extends Plugin> Collection<E> getDefinedPlugins(Class<E> pluginType) throws KettleConfigException {
        Class type = pluginType == JobPlugin.class ? Job.class : Step.class;
        for (Map.Entry<Class<? extends Annotation>, Set<? extends Plugin>> entry : this.plugins.entrySet()) {
            if (entry.getKey() != type) continue;
            return entry.getValue();
        }
        throw new KettleConfigException("Invalid plugin type: " + type);
    }

    private void build(FileObject parent, boolean isJar) throws KettleConfigException {
        try {
            FileObject xml = null;
            if (isJar) {
                FileObject exploded = this.explodeJar(parent);
                ResolverUtil resPlugins = new ResolverUtil();
                File fparent = new File(exploded.getURL().getFile());
                File[] files = fparent.listFiles(new JarNameFilter());
                URL[] classpath = new URL[files.length];
                for (int i = 0; i < files.length; ++i) {
                    classpath[i] = files[i].toURI().toURL();
                }
                PDIClassLoader cl = new PDIClassLoader(classpath, Thread.currentThread().getContextClassLoader());
                resPlugins.setClassLoader((ClassLoader)cl);
                for (FileObject couldBeJar : exploded.getChildren()) {
                    if (!couldBeJar.getName().getExtension().equals(JAR)) continue;
                    resPlugins.loadImplementationsInJar("", couldBeJar.getURL(), this.tests.values().toArray(new ResolverUtil.Test[2]));
                }
                for (Class match : resPlugins.getClasses()) {
                    for (Class<? extends Annotation> cannot : this.tests.keySet()) {
                        Annotation annot = match.getAnnotation(cannot);
                        if (annot == null) continue;
                        this.fromAnnotation(annot, exploded, match);
                    }
                }
                xml = exploded.getChild("plugin.xml");
                if (xml == null || !xml.exists()) {
                    return;
                }
                parent = exploded;
            } else {
                xml = parent.getChild("plugin.xml");
            }
            if (xml != null && xml.isReadable()) {
                this.fromXML(xml, parent);
            }
        }
        catch (Exception e) {
            throw new KettleConfigException((Throwable)e);
        }
    }

    private void fromXML(FileObject xml, FileObject parent) throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(KettleVFS.getInputStream((FileObject)xml));
        Node plugin = XMLHandler.getSubNode((Node)doc, (String)"plugin");
        String id = XMLHandler.getTagAttribute((Node)plugin, (String)"id");
        String description = XMLHandler.getTagAttribute((Node)plugin, (String)"description");
        String iconfile = XMLHandler.getTagAttribute((Node)plugin, (String)"iconfile");
        String tooltip = XMLHandler.getTagAttribute((Node)plugin, (String)"tooltip");
        String classname = XMLHandler.getTagAttribute((Node)plugin, (String)"classname");
        String category = XMLHandler.getTagAttribute((Node)plugin, (String)"category");
        String errorHelpfile = XMLHandler.getTagAttribute((Node)plugin, (String)"errorhelpfile");
        Node locCatsNode = XMLHandler.getSubNode((Node)plugin, (String)"localized_category");
        int nrLocCats = XMLHandler.countNodes((Node)locCatsNode, (String)"category");
        Hashtable<String, String> localizedCategories = new Hashtable<String, String>();
        for (int j = 0; j < nrLocCats; ++j) {
            Node locCatNode = XMLHandler.getSubNodeByNr((Node)locCatsNode, (String)"category", (int)j);
            String locale = XMLHandler.getTagAttribute((Node)locCatNode, (String)"locale");
            String locCat = XMLHandler.getNodeValue((Node)locCatNode);
            if (Const.isEmpty((String)locale) || Const.isEmpty((String)locCat)) continue;
            localizedCategories.put(locale.toLowerCase(), locCat);
        }
        Node locDescsNode = XMLHandler.getSubNode((Node)plugin, (String)"localized_description");
        int nrLocDescs = XMLHandler.countNodes((Node)locDescsNode, (String)"description");
        Hashtable<String, String> localizedDescriptions = new Hashtable<String, String>();
        for (int j = 0; j < nrLocDescs; ++j) {
            Node locDescNode = XMLHandler.getSubNodeByNr((Node)locDescsNode, (String)"description", (int)j);
            String locale = XMLHandler.getTagAttribute((Node)locDescNode, (String)"locale");
            String locDesc = XMLHandler.getNodeValue((Node)locDescNode);
            if (Const.isEmpty((String)locale) || Const.isEmpty((String)locDesc)) continue;
            localizedDescriptions.put(locale.toLowerCase(), locDesc);
        }
        Node locTipsNode = XMLHandler.getSubNode((Node)plugin, (String)"localized_tooltip");
        int nrLocTips = XMLHandler.countNodes((Node)locTipsNode, (String)"tooltip");
        Hashtable<String, String> localizedTooltips = new Hashtable<String, String>();
        for (int j = 0; j < nrLocTips; ++j) {
            Node locTipNode = XMLHandler.getSubNodeByNr((Node)locTipsNode, (String)"tooltip", (int)j);
            String locale = XMLHandler.getTagAttribute((Node)locTipNode, (String)"locale");
            String locTip = XMLHandler.getNodeValue((Node)locTipNode);
            if (Const.isEmpty((String)locale) || Const.isEmpty((String)locTip)) continue;
            localizedTooltips.put(locale.toLowerCase(), locTip);
        }
        Node libsnode = XMLHandler.getSubNode((Node)plugin, (String)"libraries");
        int nrlibs = XMLHandler.countNodes((Node)libsnode, (String)"library");
        String[] jarfiles = new String[nrlibs];
        for (int j = 0; j < nrlibs; ++j) {
            Node libnode = XMLHandler.getSubNodeByNr((Node)libsnode, (String)"library", (int)j);
            String jarfile = XMLHandler.getTagAttribute((Node)libnode, (String)"name");
            jarfiles[j] = parent.resolveFile(jarfile).getURL().getFile();
        }
        ArrayList<URL> classpath = new ArrayList<URL>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new FileSystemResourceLoader());
        for (int i = 0; i < jarfiles.length; ++i) {
            try {
                Resource[] paths;
                for (Object path : paths = resolver.getResources(jarfiles[i])) {
                    classpath.add(path.getURL());
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        URL[] urls = classpath.toArray(new URL[classpath.size()]);
        PDIClassLoader cl = new PDIClassLoader(urls, Thread.currentThread().getContextClassLoader());
        String iconFilename = parent.resolveFile(iconfile).getURL().getFile();
        Class<?> pluginClass = cl.loadClass(classname);
        if (JobEntryInterface.class.isAssignableFrom(pluginClass)) {
            Set<? extends Plugin> jps = this.plugins.get(Job.class);
            JobPlugin plg = new JobPlugin(2, id, description, tooltip, parent.getName().getURI(), jarfiles, iconFilename, classname, category);
            plg.setClassLoader((ClassLoader)cl);
            plg.setLocalizedCategories(localizedCategories);
            plg.setLocalizedDescriptions(localizedDescriptions);
            plg.setLocalizedTooltips(localizedTooltips);
            jps.add(plg);
        } else {
            Object path;
            String errorHelpFileFull = errorHelpfile;
            path = parent.getName().getURI();
            if (!Const.isEmpty((String)errorHelpfile)) {
                errorHelpFileFull = path == null ? errorHelpfile : (String)path + Const.FILE_SEPARATOR + errorHelpfile;
            }
            StepPlugin sp = new StepPlugin(2, new String[]{id}, description, tooltip, (String)path, jarfiles, iconFilename, classname, category, errorHelpFileFull);
            sp.setLocalizedCategories(localizedCategories);
            sp.setLocalizedDescriptions(localizedDescriptions);
            sp.setLocalizedTooltips(localizedTooltips);
            Set<? extends Plugin> sps = this.plugins.get(Step.class);
            sps.add(sp);
        }
    }

    private void fromAnnotation(Annotation annot, FileObject directory, Class<?> match) throws IOException {
        Class<? extends Annotation> type = annot.annotationType();
        if (type == Job.class) {
            Job jobAnnot = (Job)annot;
            String[] libs = this.getLibs(directory);
            Set<? extends Plugin> jps = this.plugins.get(Job.class);
            JobPlugin pg = new JobPlugin(2, jobAnnot.id(), jobAnnot.type().getDescription(), jobAnnot.tooltip(), directory.getURL().getFile(), libs, jobAnnot.image(), match.getName(), jobAnnot.categoryDescription());
            pg.setClassLoader(match.getClassLoader());
            jps.add(pg);
        } else if (type == Step.class) {
            Step jobAnnot = (Step)annot;
            String[] libs = this.getLibs(directory);
            Set<? extends Plugin> jps = this.plugins.get(Step.class);
            StepPlugin pg = new StepPlugin(2, jobAnnot.name(), jobAnnot.description(), jobAnnot.tooltip(), directory.getURL().getFile(), libs, jobAnnot.image(), match.getName(), jobAnnot.categoryDescription(), "");
            pg.setClassLoader(match.getClassLoader());
            jps.add(pg);
        }
    }

    private String[] getLibs(FileObject pluginLocation) throws IOException {
        File[] jars = new File(pluginLocation.getURL().getFile()).listFiles(new JarNameFilter());
        Object[] libs = new String[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            libs[i] = jars[i].getPath();
        }
        Arrays.sort(libs);
        int idx = Arrays.binarySearch(libs, DEFAULT_LIB);
        Object[] retVal = null;
        if (idx < 0) {
            String[] completeLib = new String[libs.length + 1];
            System.arraycopy(libs, 0, completeLib, 0, libs.length);
            completeLib[libs.length] = pluginLocation.resolveFile(DEFAULT_LIB).getURL().getFile();
            retVal = completeLib;
        } else {
            retVal = libs;
        }
        return retVal;
    }

    private FileObject explodeJar(FileObject parent) throws FileSystemException {
        FileObject dest = VFS.getManager().resolveFile(Const.getKettleDirectory() + File.separator + WORK_DIR);
        dest.createFolder();
        FileObject destFile = dest.resolveFile(parent.getName().getBaseName());
        if (!destFile.exists()) {
            destFile.createFolder();
        } else {
            for (FileObject child : destFile.getChildren()) {
                child.delete((FileSelector)new AllFileSelector());
            }
        }
        destFile.copyFrom(!(parent instanceof JarFileObject) ? VFS.getManager().resolveFile("jar:" + parent.getName().getURI()) : parent, (FileSelector)new AllFileSelector());
        return destFile;
    }

    private static class JarNameFilter
    implements FilenameFilter {
        private JarNameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(PluginLoader.JAR) || name.endsWith(".zip");
        }
    }
}

