/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.duo.api;

import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;

public class DuoCookie {
    private static final Pattern COOKIE_FORMAT = Pattern.compile("([^|]+)\\|([^|]+)\\|([0-9]+)");
    private static final int USERNAME_GROUP = 1;
    private static final int INTEGRATION_KEY_GROUP = 2;
    private static final int EXPIRATION_TIMESTAMP_GROUP = 3;
    private final String username;
    private final String integrationKey;
    private final long expires;

    public DuoCookie(String username, String integrationKey, long expires) {
        this.username = username;
        this.integrationKey = integrationKey;
        this.expires = expires;
    }

    public String getUsername() {
        return this.username;
    }

    public String getIntegrationKey() {
        return this.integrationKey;
    }

    public long getExpirationTimestamp() {
        return this.expires;
    }

    public static long currentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public boolean isExpired() {
        return DuoCookie.currentTimestamp() >= this.expires;
    }

    public static DuoCookie parseDuoCookie(String str) throws GuacamoleException {
        long expires;
        String data;
        try {
            data = new String(BaseEncoding.base64().decode((CharSequence)str), "UTF-8");
        }
        catch (IllegalArgumentException e) {
            throw new GuacamoleClientException("Username is not correctly encoded as base64.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
        Matcher matcher = COOKIE_FORMAT.matcher(data);
        if (!matcher.matches()) {
            throw new GuacamoleClientException("Format of base64-encoded username is invalid.");
        }
        String username = matcher.group(1);
        String key = matcher.group(2);
        try {
            expires = Long.parseLong(matcher.group(3));
        }
        catch (NumberFormatException e) {
            throw new GuacamoleClientException("Expiration timestamp is not valid.", (Throwable)e);
        }
        return new DuoCookie(username, key, expires);
    }

    public String toString() {
        try {
            String data = this.username + "|" + this.integrationKey + "|" + this.expires;
            return BaseEncoding.base64().encode(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
    }
}

