/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseBase;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseDetails;
import com.oracle.bmc.database.model.GenerateAutonomousDatabaseWalletDetails;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.model.BmcException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.cloud.oracle.Bundle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class OCIProfile
implements OCISessionInitiator {
    public static final String DEFAULT_ID = "DEFAULT";
    private final String id;
    private final Path configPath;
    private long fileStamp;
    private ConfigFileAuthenticationDetailsProvider configProvider;
    private IOException initError;
    private Tenancy tenancyOpt;
    private static final Logger LOG = Logger.getLogger(OCIProfile.class.getName());
    private final Lookup lkp = Lookups.fixed((Object[])new Object[]{this});

    OCIProfile(Path configPath, String id) {
        this(configPath, id, true);
        this.init();
    }

    OCIProfile(Path configPath, String id, boolean internal) {
        if (id == null) {
            id = DEFAULT_ID;
        }
        if (configPath == null) {
            configPath = OCIManager.getDefaultConfigPath();
        }
        this.id = id;
        this.configPath = configPath;
    }

    public boolean isDefaultConfig() {
        return this.configPath.equals(OCIManager.getDefaultConfigPath());
    }

    private void init() {
        try {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                return;
            }
            long stamp = Files.getLastModifiedTime(this.configPath, new LinkOption[0]).toMillis();
            String stringPath = this.configPath.toAbsolutePath().toString();
            ConfigFileReader.ConfigFile configFile = this.id == null ? ConfigFileReader.parse((String)stringPath) : ConfigFileReader.parse((String)stringPath, (String)this.id);
            this.configProvider = new ConfigFileAuthenticationDetailsProvider(configFile);
            this.fileStamp = stamp;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "init()", ex);
            this.initError = ex;
        }
        catch (Throwable ex) {
            LOG.log(Level.INFO, "init()", ex);
            this.initError = new IOException(ex);
        }
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public String getId() {
        return this.id;
    }

    public boolean isValid() {
        return this.configProvider != null && this.fileStamp == this.configPath.toFile().lastModified();
    }

    @Override
    public BasicAuthenticationDetailsProvider getAuthenticationProvider() {
        return this.configProvider;
    }

    @Override
    public Region getRegion() {
        return this.configProvider.getRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tenancy getTenancyData() {
        if (this.configProvider == null) {
            return null;
        }
        OCIProfile oCIProfile = this;
        synchronized (oCIProfile) {
            if (this.tenancyOpt != null) return this.tenancyOpt;
            if (this.initError != null) {
                return this.tenancyOpt;
            }
        }
        try (IdentityClient identityClient = new IdentityClient((BasicAuthenticationDetailsProvider)this.configProvider);){
            identityClient.setRegion(this.configProvider.getRegion());
            GetTenancyRequest gtr = GetTenancyRequest.builder().tenancyId(this.configProvider.getTenantId()).build();
            GetTenancyResponse response = identityClient.getTenancy(gtr);
            Tenancy tenancy = response.getTenancy();
            OCIProfile oCIProfile2 = this;
            synchronized (oCIProfile2) {
                Tenancy tenancy2 = this.tenancyOpt = tenancy;
                return tenancy2;
            }
        }
        catch (Throwable t) {
            LOG.log(Level.INFO, "getTenancyData()", t);
            this.initError = new IOException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<TenancyItem> getTenancy() {
        if (this.configProvider == null) {
            return Optional.empty();
        }
        OCIProfile oCIProfile = this;
        synchronized (oCIProfile) {
            if (this.initError != null) {
                return Optional.empty();
            }
            if (this.tenancyOpt != null) {
                return Optional.of(this.createTenancyItem(this.tenancyOpt));
            }
            Tenancy t = this.getTenancyData();
            Optional<Object> optional = t == null ? Optional.empty() : Optional.of(this.createTenancyItem(t));
            return optional;
        }
    }

    @Override
    public <T> T newClient(Class<T> clientClass) {
        try {
            T client = clientClass.getConstructor(BasicAuthenticationDetailsProvider.class).newInstance(this.configProvider);
            Method setRegion = clientClass.getMethod("setRegion", Region.class);
            setRegion.invoke(client, this.configProvider.getRegion());
            return client;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("Could not initialize client: " + clientClass);
        }
    }

    private TenancyItem createTenancyItem(Tenancy tenancy) {
        String regionCode = this.configProvider.getRegion().getRegionCode();
        TenancyItem item = new TenancyItem(OCID.of(tenancy.getId(), "Tenancy"), tenancy.getName(), regionCode);
        item.setDescription(Bundle.LBL_HomeRegion(tenancy.getHomeRegionKey()));
        return item;
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    public ConfigFileAuthenticationDetailsProvider getConfigProvider() {
        return this.configProvider;
    }

    public Path downloadWallet(OCIItem dbInstance, String password, String parentPath) throws FileNotFoundException, IOException {
        if (this.configProvider == null) {
            return null;
        }
        try (DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)this.configProvider);){
            ZipEntry entry;
            GenerateAutonomousDatabaseWalletDetails details = GenerateAutonomousDatabaseWalletDetails.builder().password(password).build();
            GenerateAutonomousDatabaseWalletRequest generateAutonomousDatabaseWalletRequest = GenerateAutonomousDatabaseWalletRequest.builder().autonomousDatabaseId(dbInstance.getKey().getValue()).generateAutonomousDatabaseWalletDetails(details).build();
            GenerateAutonomousDatabaseWalletResponse response = client.generateAutonomousDatabaseWallet(generateAutonomousDatabaseWalletRequest);
            Path walletPath = null;
            int i = 1;
            while (Files.exists(walletPath = walletPath == null ? Paths.get(parentPath, dbInstance.getName()) : Paths.get(parentPath, dbInstance.getName() + "_" + i++), new LinkOption[0])) {
            }
            Files.createDirectory(walletPath, new FileAttribute[0]);
            ZipInputStream zin = new ZipInputStream(response.getInputStream());
            while ((entry = zin.getNextEntry()) != null) {
                Path entryPath = walletPath.resolve(entry.getName());
                Files.copy(zin, entryPath, new CopyOption[0]);
            }
            Path path = walletPath;
            return path;
        }
    }

    public Optional<String> createAutonomousDatabase(CompartmentItem compartment, String dbName, char[] password) {
        if (this.configProvider == null) {
            return Optional.empty();
        }
        DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)this.configProvider);
        try {
            Object object;
            CreateAutonomousDatabaseDetails createAutonomousDatabaseBase = CreateAutonomousDatabaseDetails.builder().compartmentId(compartment.getKey().getValue()).dbName(dbName).adminPassword(new String(password)).cpuCoreCount(Integer.valueOf(1)).dataStorageSizeInTBs(Integer.valueOf(1)).build();
            CreateAutonomousDatabaseRequest createAutonomousDatabaseRequest = CreateAutonomousDatabaseRequest.builder().createAutonomousDatabaseDetails((CreateAutonomousDatabaseBase)createAutonomousDatabaseBase).build();
            try {
                object = client.createAutonomousDatabase(createAutonomousDatabaseRequest);
            }
            catch (BmcException e) {
                Optional<String> optional = Optional.of(e.getMessage());
                client.close();
                return optional;
            }
            object = Optional.empty();
            return object;
        }
        finally {
            try {
                client.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.id);
        hash = 19 * hash + Objects.hashCode(this.configPath);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OCIProfile other = (OCIProfile)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.configPath, other.configPath);
    }
}

