/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class FormalParameter
extends ASTNode
implements Attributed {
    private int modifier;
    private Expression parameterType;
    private Expression parameterName;
    private Expression defaultValue;
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public FormalParameter(int start, int end, Integer modifier, Expression type, Expression parameterName, Expression defaultValue) {
        this(start, end, modifier == null ? 0 : modifier, type, parameterName, defaultValue, Collections.emptyList());
    }

    public FormalParameter(int start, int end, Expression type, Expression parameterName, Expression defaultValue) {
        this(start, end, 0, type, parameterName, defaultValue, Collections.emptyList());
    }

    public FormalParameter(int start, int end, Expression type, Reference parameterName, Expression defaultValue) {
        this(start, end, type, (Expression)parameterName, defaultValue);
    }

    public FormalParameter(int start, int end, Integer modifier, Expression type, Expression parameterName) {
        this(start, end, modifier, type, parameterName, null);
    }

    public FormalParameter(int start, int end, Expression type, Expression parameterName) {
        this(start, end, type, parameterName, null);
    }

    public FormalParameter(int start, int end, Expression type, Reference parameterName) {
        this(start, end, type, (Expression)parameterName, null);
    }

    private FormalParameter(int start, int end, int modifier, Expression parameterType, Expression parameterName, Expression defaultValue, List<Attribute> attributes) {
        super(start, end);
        this.attributes.addAll(attributes);
        this.modifier = modifier;
        this.parameterType = parameterType;
        this.parameterName = parameterName;
        this.defaultValue = defaultValue;
    }

    public static FormalParameter create(FormalParameter parameter, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? parameter.getStartOffset() : attributes.get(0).getStartOffset();
        return new FormalParameter(start, parameter.getEndOffset(), parameter.getModifier(), parameter.getParameterType(), parameter.getParameterName(), parameter.getDefaultValue(), attributes);
    }

    public int getModifier() {
        return this.modifier;
    }

    public String getModifierString() {
        return BodyDeclaration.Modifier.toString(this.modifier);
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.getDefaultValue() == null && !this.isVariadic();
    }

    public boolean isOptional() {
        return !this.isMandatory();
    }

    public boolean isVariadic() {
        if (this.isReference()) {
            return ((Reference)this.getParameterName()).getExpression() instanceof Variadic;
        }
        return this.getParameterName() instanceof Variadic;
    }

    public boolean isReference() {
        return this.getParameterName() instanceof Reference;
    }

    public boolean isNullableType() {
        return this.getParameterType() instanceof NullableType;
    }

    public boolean isUnionType() {
        return this.getParameterType() instanceof UnionType;
    }

    public boolean isIntersectionType() {
        return this.getParameterType() instanceof IntersectionType;
    }

    public Expression getParameterName() {
        return this.parameterName;
    }

    public Expression getParameterType() {
        return this.parameterType;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public boolean isAttributed() {
        return !this.attributes.isEmpty();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        Object modifierString = this.getModifierString();
        if (modifierString != null && !((String)modifierString).isEmpty()) {
            modifierString = (String)modifierString + " ";
        }
        return sbAttributes.toString() + (String)modifierString + (String)(this.getParameterType() == null ? "" : this.getParameterType() + " ") + this.getParameterName() + (String)(this.isMandatory() ? "" : " = " + this.getDefaultValue());
    }
}

