/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.io.File;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.openide.util.NbBundle;

public class QFileNode
extends VCSFileNode<FileInformation> {
    public static final VCSCommitOptions INCLUDE = new VCSCommitOptions.Commit(NbBundle.getMessage(QFileNode.class, (String)"IncludeOption.name"));
    public static final VCSCommitOptions EXCLUDE = new VCSCommitOptions.Commit(NbBundle.getMessage(QFileNode.class, (String)"ExcludeOption.name"));
    private final FileInformation fi;

    public QFileNode(File root, File file) {
        this(root, file, null);
    }

    QFileNode(File repository, File file, FileInformation fi) {
        super(repository, file);
        this.fi = fi;
    }

    public FileInformation getInformation() {
        return this.fi == null ? Mercurial.getInstance().getFileStatusCache().getStatus(this.getFile()) : this.fi;
    }

    public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
        if (withExclusions && HgModuleConfig.getDefault().isExcludedFromCommit(this.getFile().getAbsolutePath())) {
            return EXCLUDE;
        }
        if ((this.getInformation().getStatus() & 0x900) != 0) {
            return VCSCommitOptions.COMMIT_REMOVE;
        }
        if ((this.getInformation().getStatus() & 4) != 0) {
            return HgModuleConfig.getDefault().getExludeNewFiles() ? EXCLUDE : INCLUDE;
        }
        return INCLUDE;
    }
}

