/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonRegexParser;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.function.BiPredicate;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public final class PythonFlavor
extends RegexFlavor {
    public static final PythonFlavor INSTANCE = new PythonFlavor();

    private PythonFlavor() {
        super(253);
    }

    @Override
    public RegexValidator createValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return new PythonRegexParser(language, source, compilationBuffer);
    }

    @Override
    public BiPredicate<Integer, Integer> getEqualsIgnoreCasePredicate(RegexAST ast) {
        if (ast.getOptions().getEncoding() == Encodings.UTF_32) {
            return PythonFlavor::equalsIgnoreCaseUnicode;
        }
        assert (ast.getOptions().getEncoding() == Encodings.LATIN_1);
        return CaseFoldData.CaseFoldUnfoldAlgorithm.PythonAscii.getEqualsPredicate();
    }

    private static boolean equalsIgnoreCaseUnicode(int codePointA, int codePointB) {
        return UCharacter.toLowerCase((int)codePointA) == UCharacter.toLowerCase((int)codePointB);
    }
}

