/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.reload;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.reload.Bundle;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class GradleReloadImplementation
implements ProjectReloadImplementation {
    private static final Logger LOG = Logger.getLogger(GradleReloadImplementation.class.getName());
    private final Project project;
    private final PropertyChangeListener reloadL;
    private Reference<ProjectReloadImplementation.ProjectStateData> last = new WeakReference<Object>(null);
    private static final String[] OFFLINE_EXCEPTION_CLASSES = new String[]{"org.gradle.api.plugins.UnknownPluginException", "org.netbeans.modules.gradle.tooling.NeedOnlineModeException"};
    private static final Pattern OFFLINE_EXCEPTIONS_PATTERN = Pattern.compile(String.join((CharSequence)"|", OFFLINE_EXCEPTION_CLASSES));

    public GradleReloadImplementation(Project project) {
        this.project = project;
        this.reloadL = pch -> {
            if ("ProjectInfo".equals(pch.getPropertyName())) {
                LOG.log(Level.FINE, "Project {0} reloaded", project);
            }
        };
        NbGradleProject gp = NbGradleProject.get((Project)project);
        gp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.reloadL, (Object)gp));
    }

    public ProjectReloadImplementation.ProjectStateData getLastCachedData() {
        return this.last.get();
    }

    private static void includeFile(File f, Collection<FileObject> into) {
        if (f == null) {
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)f);
        if (fo == null) {
            return;
        }
        into.add(fo);
    }

    private Set<FileObject> findProjectFiles(boolean forReload) {
        NbGradleProject nbgp = NbGradleProject.get((Project)this.project);
        GradleFiles gf = nbgp.getGradleFiles();
        HashSet<FileObject> files = new HashSet<FileObject>();
        if (forReload) {
            gf.getProjectFiles().forEach(f -> GradleReloadImplementation.includeFile(f, files));
            GradleReloadImplementation.includeFile(gf.getFile(GradleFiles.Kind.ROOT_PROPERTIES), files);
            GradleReloadImplementation.includeFile(gf.getFile(GradleFiles.Kind.USER_PROPERTIES), files);
            GradleReloadImplementation.includeFile(gf.getFile(GradleFiles.Kind.ROOT_SCRIPT), files);
        } else {
            File f2 = gf.getSettingsScript();
            if (gf.isRootProject() || f2.getParentFile().equals(gf.getProjectDir())) {
                GradleReloadImplementation.includeFile(gf.getSettingsScript(), files);
            }
            GradleReloadImplementation.includeFile(gf.getBuildScript(), files);
        }
        GradleReloadImplementation.includeFile(gf.getFile(GradleFiles.Kind.PROJECT_PROPERTIES), files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectReloadImplementation.ProjectStateData getProjectData() {
        ProjectReload.Quality q;
        NbGradleProject nbgp = NbGradleProject.get((Project)this.project);
        long time = nbgp.getEvaluateTime();
        GradleReloadImplementation gradleReloadImplementation = this;
        synchronized (gradleReloadImplementation) {
            ProjectReloadImplementation.ProjectStateData d = this.last.get();
            if (d != null && d.getTimestamp() == time) {
                return d;
            }
        }
        Set<FileObject> files = this.findProjectFiles(true);
        NbGradleProject.Quality pq = nbgp.getQuality();
        switch (pq) {
            case FALLBACK: {
                q = ProjectReload.Quality.FALLBACK;
                if (ProjectTrust.getDefault().isTrusted(this.project)) {
                    q = ProjectReload.Quality.FALLBACK;
                    break;
                }
                q = ProjectReload.Quality.UNTRUSTED;
                break;
            }
            case EVALUATED: {
                q = ProjectReload.Quality.BROKEN;
                break;
            }
            case SIMPLE: {
                q = ProjectReload.Quality.SIMPLE;
                break;
            }
            case FULL: {
                q = ProjectReload.Quality.LOADED;
                break;
            }
            case FULL_ONLINE: {
                q = ProjectReload.Quality.RESOLVED;
                break;
            }
            default: {
                q = ProjectReload.Quality.BROKEN;
            }
        }
        ProjectReloadImplementation.ProjectStateData sd = ProjectReloadImplementation.ProjectStateData.builder((ProjectReload.Quality)q).files(files).attachLookup(NbGradleProject.get((Project)this.project).curretLookup()).timestamp(time).build();
        GradleReloadImplementation gradleReloadImplementation2 = this;
        synchronized (gradleReloadImplementation2) {
            this.last = new WeakReference<ProjectReloadImplementation.ProjectStateData>(sd);
        }
        return sd;
    }

    public CompletableFuture reload(Project project, ProjectReload.StateRequest stateRequest, ProjectReloadImplementation.LoadContext context) {
        NbGradleProject.Quality aimQuality;
        if (!(project instanceof NbGradleProjectImpl)) {
            return null;
        }
        NbGradleProjectImpl nbgp = (NbGradleProjectImpl)project;
        boolean offline = false;
        switch (stateRequest.getMinQuality()) {
            case NONE: {
                if (stateRequest.getTargetQuality().isAtLeast(ProjectReload.Quality.SIMPLE)) {
                    aimQuality = NbGradleProject.Quality.FALLBACK;
                    offline = true;
                    break;
                }
                return CompletableFuture.completedFuture(this.getProjectData());
            }
            case FALLBACK: {
                aimQuality = NbGradleProject.Quality.FALLBACK;
                break;
            }
            case BROKEN: {
                aimQuality = NbGradleProject.Quality.EVALUATED;
                break;
            }
            case SIMPLE: {
                aimQuality = NbGradleProject.Quality.SIMPLE;
                break;
            }
            case LOADED: {
                aimQuality = NbGradleProject.Quality.FULL;
                break;
            }
            case CONSISTENT: 
            case RESOLVED: {
                aimQuality = stateRequest.isOfflineOperation() ? NbGradleProject.Quality.FULL : NbGradleProject.Quality.FULL_ONLINE;
                break;
            }
            default: {
                throw new AssertionError((Object)stateRequest.getMinQuality().name());
            }
        }
        if (stateRequest.isGrantTrust()) {
            ProjectTrust.getDefault().isTrustedPermanently(project);
        }
        LOG.log(Level.FINE, "Request to reload {0}: aimedQuality={1}, force={2}", new Object[]{project, aimQuality, stateRequest.isForceReload()});
        CompletableFuture content = new CompletableFuture();
        CompletableFuture loadFuture = nbgp.projectWithQualityTask(NbGradleProject.loadOptions((NbGradleProject.Quality)aimQuality).setDescription(stateRequest.getReason()).setForce(stateRequest.isForceReload()).setCheckFiles(stateRequest.isConsistent()).setOffline(stateRequest.isOfflineOperation() || offline));
        loadFuture.thenAccept(p -> {
            GradleBaseProject gbp;
            boolean offlineError;
            NbGradleProject gp = NbGradleProject.get((Project)project);
            LOG.log(Level.FINE, "Project {0} reload complete, quality: {1}, time: {2}", new Object[]{project, gp.getQuality(), gp.getEvaluateTime()});
            boolean failed = gp.getQuality().worseThan(aimQuality);
            if (stateRequest.getMinQuality() == ProjectReload.Quality.RESOLVED && gp.getQuality().atLeast(NbGradleProject.Quality.FULL)) {
                failed = false;
            }
            if (failed && (offlineError = (gbp = GradleBaseProject.get((Project)project)).getProblems().stream().anyMatch(prb -> OFFLINE_EXCEPTIONS_PATTERN.matcher(prb.getErrorClass()).find()))) {
                ProjectReloadImplementation.PartialLoadException partialLoad = new ProjectReloadImplementation.PartialLoadException(this.getProjectData(), Bundle.ERROR_NeedOnlineOperation(ProjectUtils.getInformation((Project)project).getDisplayName()), (Throwable)new ProjectOperationException(project, ProjectOperationException.State.OFFLINE, Bundle.ERROR_NeedOnlineOperation(ProjectUtils.getInformation((Project)project).getDisplayName())));
                content.completeExceptionally((Throwable)partialLoad);
                return;
            }
            content.complete(this.getProjectData());
        });
        return content;
    }
}

