/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.util.List;

public final class CompoundCharSequence
implements CharSequence {
    private List<CharSequence> parts;
    private int[] partBoundaries;
    private int startOffset;
    private volatile int partNo;
    private int len;

    public CompoundCharSequence(int startOffset, List<CharSequence> parts, int len) {
        this.startOffset = startOffset;
        this.parts = parts;
        this.partBoundaries = new int[parts.size()];
        if (startOffset >= parts.get(0).length()) {
            throw new IllegalArgumentException();
        }
        int pos = -startOffset;
        for (int i = 0; pos < len && i < parts.size(); ++i) {
            this.partBoundaries[i] = pos += parts.get(i).length();
        }
        this.len = len == -1 ? this.partBoundaries[this.partBoundaries.length - 1] : len;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.len) {
            throw new StringIndexOutOfBoundsException(index);
        }
        int pn = this.partNo;
        if (this.partBoundaries[pn] > index && (pn == 0 || this.partBoundaries[pn - 1] <= index)) {
            int start = pn == 0 ? 0 : this.partBoundaries[pn - 1];
            return this.parts.get(pn).charAt(index - start);
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.partBoundaries[i] <= index) continue;
            int start = i == 0 ? this.startOffset : this.partBoundaries[i - 1];
            this.partNo = i;
            return this.parts.get(i).charAt(index - start);
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end > this.len) {
            throw new StringIndexOutOfBoundsException(end);
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.partBoundaries[i] <= start) continue;
            int sO = i == 0 ? 0 : this.partBoundaries[i - 1];
            return new CompoundCharSequence(start - sO, this.parts.subList(i, this.parts.size()), end - start);
        }
        throw new StringIndexOutOfBoundsException(start);
    }
}

