/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.catalog.impl.sun.Catalog;
import org.netbeans.modules.xml.catalog.impl.sun.res.Bundle;
import org.netbeans.modules.xml.catalog.lib.Util;

public class CatalogCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -1437233290256708364L;
    Catalog model = null;
    private JTextArea descTextArea;
    private JLabel locationLabel;
    private JTextField locationTextField;
    private JCheckBox preferCheckBox;
    private JButton selectButton;
    private JLabel warningLabel;

    public CatalogCustomizer() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_CatalogCustomizer());
        this.locationLabel.setDisplayedMnemonic(Bundle.CatalogCustomizer_locationLabel_mneString().charAt(0));
        this.locationTextField.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_locationTextField());
        this.preferCheckBox.setMnemonic(Bundle.MNE_preference().charAt(0));
        this.preferCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_preference());
        this.selectButton.setMnemonic(Bundle.MNE_file().charAt(0));
        this.selectButton.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_file());
        this.updateValidity();
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationTextField = new JTextField();
        this.selectButton = new JButton();
        this.preferCheckBox = new JCheckBox();
        this.descTextArea = new JTextArea();
        this.warningLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.locationLabel.setLabelFor(this.locationTextField);
        this.locationLabel.setText(Bundle.CatalogCustomizer_locationLabel_text());
        this.add((Component)this.locationLabel, new GridBagConstraints());
        this.locationTextField.setColumns(40);
        this.locationTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogCustomizer.this.locationTextFieldActionPerformed(evt);
            }
        });
        this.locationTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CatalogCustomizer.this.locationTextFieldFocusLost(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.locationTextField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/sun/res/Bundle");
        this.selectButton.setText(bundle.getString("PROP_choose_file"));
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogCustomizer.this.selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.selectButton, gridBagConstraints);
        this.preferCheckBox.setText(bundle.getString("LBL_preference"));
        this.preferCheckBox.setToolTipText(Bundle.HINT_pp());
        this.preferCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CatalogCustomizer.this.preferCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.add((Component)this.preferCheckBox, gridBagConstraints);
        this.descTextArea.setEditable(false);
        this.descTextArea.setColumns(40);
        this.descTextArea.setFont(UIManager.getFont("Label.font"));
        this.descTextArea.setForeground(new Color(102, 102, 153));
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setRows(4);
        this.descTextArea.setText(Bundle.DESC_catalog_fmts());
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.warningLabel.setForeground(new Color(255, 0, 0));
        this.warningLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.add((Component)this.warningLabel, gridBagConstraints);
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        File f = Util.selectCatalogFile("txt xml cat catalog");
        if (f == null) {
            return;
        }
        try {
            String location = f.toURL().toExternalForm();
            this.locationTextField.setText(location);
            this.model.setLocation(location);
            this.updateValidity();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void preferCheckBoxStateChanged(ChangeEvent evt) {
        if (this.model != null) {
            this.model.setPreferPublic(this.preferCheckBox.isSelected());
        }
    }

    private void locationTextFieldFocusLost(FocusEvent evt) {
        this.model.setLocation(this.locationTextField.getText());
        this.updateValidity();
    }

    private void locationTextFieldActionPerformed(ActionEvent evt) {
        this.model.setLocation(this.locationTextField.getText());
        this.updateValidity();
    }

    @Override
    public void setObject(Object peer) {
        if (!(peer instanceof Catalog)) {
            throw new IllegalArgumentException("Catalog instance expected (" + peer.getClass() + ").");
        }
        this.model = (Catalog)peer;
        this.locationTextField.setText(this.model.getLocation());
        this.preferCheckBox.setSelected(this.model.isPreferPublic());
        this.updateValidity();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }

    private void updateValidity() {
        this.warningLabel.setText(this.model != null && !this.model.isValid() ? Bundle.TEXT_catalog_not_valid() : " ");
    }
}

