/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.testng.collections.Lists;
import org.testng.internal.PackageUtils;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;

public class XmlPackage {
    private String m_name;
    private List<String> m_include = Lists.newArrayList();
    private List<String> m_exclude = Lists.newArrayList();
    private List<XmlClass> m_xmlClasses = null;

    public XmlPackage() {
    }

    public XmlPackage(String string) {
        this.m_name = string;
    }

    public List<String> getExclude() {
        return this.m_exclude;
    }

    public void setExclude(List<String> list) {
        this.m_exclude = list;
    }

    public List<String> getInclude() {
        return this.m_include;
    }

    public void setInclude(List<String> list) {
        this.m_include = list;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public List<XmlClass> getXmlClasses() {
        if (null == this.m_xmlClasses) {
            this.m_xmlClasses = this.initializeXmlClasses();
        }
        return this.m_xmlClasses;
    }

    private List<XmlClass> initializeXmlClasses() {
        List<XmlClass> list = Lists.newArrayList();
        try {
            String[] stringArray = PackageUtils.findClassesInPackage(this.m_name, this.m_include, this.m_exclude);
            int n = 0;
            for (String string : stringArray) {
                list.add(new XmlClass(string, n++, false));
            }
        }
        catch (IOException iOException) {
            Utils.log("XmlPackage", 1, iOException.getMessage());
        }
        return list;
    }

    public String toXml(String string) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        Properties properties = new Properties();
        properties.setProperty("name", this.getName());
        if (this.getInclude().isEmpty() && this.getExclude().isEmpty()) {
            xMLStringBuffer.addEmptyElement("package", properties);
        } else {
            Properties properties2;
            xMLStringBuffer.push("package", properties);
            for (String string2 : this.getInclude()) {
                properties2 = new Properties();
                properties2.setProperty("name", string2);
                xMLStringBuffer.addEmptyElement("include", properties2);
            }
            for (String string2 : this.getExclude()) {
                properties2 = new Properties();
                properties2.setProperty("name", string2);
                xMLStringBuffer.addEmptyElement("exclude", properties2);
            }
            xMLStringBuffer.pop("package");
        }
        return xMLStringBuffer.toXML();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_exclude == null ? 0 : this.m_exclude.hashCode());
        n = 31 * n + (this.m_include == null ? 0 : this.m_include.hashCode());
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        n = 31 * n + (this.m_xmlClasses == null ? 0 : this.m_xmlClasses.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != object.getClass()) {
            return XmlSuite.f();
        }
        XmlPackage xmlPackage = (XmlPackage)object;
        if (this.m_exclude == null ? xmlPackage.m_exclude != null : !this.m_exclude.equals(xmlPackage.m_exclude)) {
            return XmlSuite.f();
        }
        if (this.m_include == null ? xmlPackage.m_include != null : !this.m_include.equals(xmlPackage.m_include)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? xmlPackage.m_name != null : !this.m_name.equals(xmlPackage.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_xmlClasses == null ? xmlPackage.m_xmlClasses != null : !this.m_xmlClasses.equals(xmlPackage.m_xmlClasses)) {
            return XmlSuite.f();
        }
        return true;
    }
}

