/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.dialogs.UpgradeFormatDialog;

public class ChangeFormatDialog
extends UpgradeFormatDialog {
    private final boolean myWcRootIsAbove;

    public ChangeFormatDialog(Project project, File path, boolean canBeParent, boolean wcRootIsAbove) {
        super(project, path, canBeParent, false);
        this.myWcRootIsAbove = wcRootIsAbove;
        this.setTitle(SvnBundle.message("dialog.title.convert.working.copy.format", new Object[0]));
        this.init();
    }

    @Override
    @Nullable
    protected JPanel getBottomAuxiliaryPanel() {
        if (!this.myWcRootIsAbove) {
            return null;
        }
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = JBUI.insets((int)2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel iconLabel = new JLabel(Messages.getWarningIcon());
        result.add((Component)iconLabel, gb);
        ++gb.gridx;
        JLabel warningLabel = new JLabel(SvnBundle.message("label.working.copy.root.outside.text", new Object[0]));
        warningLabel.setFont(warningLabel.getFont().deriveFont(1));
        warningLabel.setUI((LabelUI)new MultiLineLabelUI());
        result.add(warningLabel);
        return result;
    }

    @Override
    @NotNull
    protected String getTopMessage() {
        String string = SvnBundle.message("label.configure.change.label", this.myPath.getAbsolutePath());
        if (string == null) {
            ChangeFormatDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NlsContexts.RadioButton
    @NotNull
    protected String getFormatText(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            ChangeFormatDialog.$$$reportNull$$$0(1);
        }
        String string = SvnBundle.message(switch (format) {
            case WorkingCopyFormat.ONE_DOT_SIX -> "radio.configure.change.auto.16format";
            case WorkingCopyFormat.ONE_DOT_SEVEN -> "radio.configure.change.auto.17format";
            case WorkingCopyFormat.ONE_DOT_EIGHT -> "radio.configure.change.auto.18format";
            default -> throw new IllegalArgumentException("unsupported format " + String.valueOf((Object)format));
        }, new Object[0]);
        if (string == null) {
            ChangeFormatDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean showHints() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/ChangeFormatDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/ChangeFormatDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFormatText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

