/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Consumer;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.ApplyFilterContext;
import com.jetbrains.rd.ide.model.FilterHighlighterModelBase;
import com.jetbrains.rd.ide.model.FilterHyperlinkModel;
import com.jetbrains.rd.ide.model.FilterKind;
import com.jetbrains.rd.ide.model.FilterNavigationContext;
import com.jetbrains.rd.ide.model.FilterProviderModel;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.filters.FrontendHeavyFilterFrame;
import com.jetbrains.rdclient.filters.FrontendHeavyFilterFrameBuffer;
import com.jetbrains.rdclient.filters.FrontendHyperlinkInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020!0 H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00010\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/jetbrains/rdclient/filters/FrontendHeavyFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/execution/filters/FilterMixin;", "project", "Lcom/intellij/openapi/project/Project;", "kind", "Lcom/jetbrains/rd/ide/model/FilterKind;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/FilterKind;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getKind", "()Lcom/jetbrains/rd/ide/model/FilterKind;", "filterProvider", "Lcom/jetbrains/rd/ide/model/FilterProviderModel;", "getFilterProvider", "()Lcom/jetbrains/rd/ide/model/FilterProviderModel;", "shouldRunHeavy", "", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "applyHeavyFilter", "", "copiedFragment", "Lcom/intellij/openapi/editor/Document;", "startOffset", "startLineNumber", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/execution/filters/FilterMixin$AdditionalHighlight;", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "highlighter", "Lcom/jetbrains/rd/ide/model/FilterHighlighterModelBase;", "frame", "Lcom/jetbrains/rdclient/filters/FrontendHeavyFilterFrame;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendHeavyFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendHeavyFilter.kt\ncom/jetbrains/rdclient/filters/FrontendHeavyFilter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n14#2:93\n*S KotlinDebug\n*F\n+ 1 FrontendHeavyFilter.kt\ncom/jetbrains/rdclient/filters/FrontendHeavyFilter\n*L\n90#1:93\n*E\n"})
public abstract class FrontendHeavyFilter
implements Filter,
FilterMixin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final FilterKind kind;
    @NotNull
    private static final Logger LOG;

    public FrontendHeavyFilter(@NotNull Project project, @NotNull FilterKind kind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.project = project;
        this.kind = kind;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FilterKind getKind() {
        return this.kind;
    }

    @Nullable
    public abstract FilterProviderModel getFilterProvider();

    public boolean shouldRunHeavy() {
        return true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return null;
    }

    public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer) {
        Intrinsics.checkNotNullParameter((Object)copiedFragment, (String)"copiedFragment");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        FilterProviderModel filterProviderModel = this.getFilterProvider();
        if (filterProviderModel == null) {
            return;
        }
        FilterProviderModel provider2 = filterProviderModel;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return;
        }
        Iterator<FrontendHeavyFilterFrame> iterator2 = new FrontendHeavyFilterFrameBuffer(copiedFragment).iterator();
        while (iterator2.hasNext()) {
            FrontendHeavyFilterFrame frame = iterator2.next();
            IRdTask task = provider2.getApplyFilter().start((Object)new ApplyFilterContext(frame.getText(), this.kind));
            SourceExKt.adviseOnce((ISource)((ISource)task.getResult()), (Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> FrontendHeavyFilter.applyHeavyFilter$lambda$0(startOffset, frame, this, consumer, arg_0));
        }
    }

    @Nullable
    public HyperlinkInfo createHyperlinkInfo(@NotNull FilterHighlighterModelBase highlighter, @NotNull FrontendHeavyFilterFrame frame) {
        HyperlinkInfo hyperlinkInfo2;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (highlighter instanceof FilterHyperlinkModel) {
            FilterProviderModel filterProviderModel = this.getFilterProvider();
            Intrinsics.checkNotNull((Object)filterProviderModel);
            hyperlinkInfo2 = new FrontendHyperlinkInfo(this.kind, (ISignal<FilterNavigationContext>)filterProviderModel.getNavigate(), (FilterHyperlinkModel)highlighter, frame);
        } else {
            hyperlinkInfo2 = null;
        }
        return hyperlinkInfo2;
    }

    private static final Unit applyHeavyFilter$lambda$0(int $startOffset, FrontendHeavyFilterFrame $frame, FrontendHeavyFilter this$0, Consumer $consumer, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int fragmentOffset = $startOffset;
        RdTaskResult rdTaskResult = it;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            ArrayList<Filter.ResultItem> result2 = new ArrayList<Filter.ResultItem>();
            TextRange rangeToHighlight = $frame.getHighlightRange();
            int maxOffset = rangeToHighlight.getEndOffset() - rangeToHighlight.getStartOffset();
            for (FilterHighlighterModelBase highlighter : (List)((RdTaskResult.Success)it).getValue()) {
                if (highlighter.getStart() >= maxOffset) continue;
                TextAttributes textAttributes = TextAttributesRegistrationHost.getTextAttributes$default((TextAttributesRegistrationHost)TextAttributesRegistrationHost.Companion.getInstance(), (TextAttributesKeyModel)highlighter.getTextAttributesKey(), null, (int)2, null);
                HyperlinkInfo linkInfo = this$0.createHyperlinkInfo(highlighter, $frame);
                int frameOffset = $frame.getHighlightRange().getStartOffset();
                int absoluteStart = fragmentOffset + frameOffset + highlighter.getStart();
                int absoluteEnd = fragmentOffset + frameOffset + highlighter.getEnd();
                Filter.ResultItem resultItem = new Filter.ResultItem(absoluteStart, absoluteEnd, linkInfo, textAttributes);
                result2.add(resultItem);
            }
            if (result2.isEmpty()) {
                return Unit.INSTANCE;
            }
            $consumer.consume((Object)new FilterMixin.AdditionalHighlight((List)result2));
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            LOG.debug("Request has been canceled");
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            LOG.error("Request has faulted");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendHeavyFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/filters/FrontendHeavyFilter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

