/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import org.jdesktop.swingx.table.NumberEditorNumberFormat;

public class NumberEditorExt
extends DefaultCellEditor {
    private static Class[] argTypes = new Class[]{String.class};
    Constructor constructor;

    public NumberEditorExt() {
        this((NumberFormat)null);
    }

    public NumberEditorExt(NumberFormat formatter) {
        super(NumberEditorExt.createFormattedTextField(formatter));
        JFormattedTextField textField = (JFormattedTextField)this.getComponent();
        textField.setName("Table.editor");
        textField.setHorizontalAlignment(4);
        textField.removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object value) {
                ((JFormattedTextField)NumberEditorExt.this.getComponent()).setValue(value);
            }

            public Object getCellEditorValue() {
                JFormattedTextField textField = (JFormattedTextField)NumberEditorExt.this.getComponent();
                try {
                    textField.commitEdit();
                    return textField.getValue();
                }
                catch (ParseException ex) {
                    return null;
                }
            }
        };
        textField.addActionListener(this.delegate);
    }

    public boolean stopCellEditing() {
        if (!((JFormattedTextField)this.editorComponent).isEditValid()) {
            return false;
        }
        return super.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        try {
            Class<?> type = table.getColumnClass(column);
            if (!Number.class.isAssignableFrom(type)) {
                throw new IllegalStateException("NumberEditor can only handle subclasses of java.lang.Number");
            }
            this.constructor = type.getConstructor(argTypes);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Number subclass must have a constructor which takes a string", ex);
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Object getCellEditorValue() {
        Number number = (Number)super.getCellEditorValue();
        if (number == null) {
            return null;
        }
        try {
            return this.constructor.newInstance(number.toString());
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("NumberEditor not propertly configured", ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("NumberEditor not propertly configured", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("NumberEditor not propertly configured", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("NumberEditor not propertly configured", ex);
        }
    }

    private static JFormattedTextField createFormattedTextField(NumberFormat formatter) {
        JFormattedTextField textField = new JFormattedTextField(new NumberEditorNumberFormat(formatter));
        for (InputMap map = textField.getInputMap(); map != null; map = map.getParent()) {
            map.remove(KeyStroke.getKeyStroke("pressed ESCAPE"));
        }
        textField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                JFormattedTextField ftf = (JFormattedTextField)input;
                return ftf.isEditValid();
            }
        });
        textField.addPropertyChangeListener("editValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.black));
                } else {
                    ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.red));
                }
            }
        });
        return textField;
    }
}

