/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.traccar.geocoder.Address;

public class AddressFormat
extends Format {
    private final String format;

    public AddressFormat() {
        this("%h %r, %t, %s, %c");
    }

    public AddressFormat(String format) {
        this.format = format;
    }

    private static String replace(String s, String key, String value) {
        s = value != null ? s.replace(key, value) : s.replaceAll("[, ]*" + key, "");
        return s;
    }

    @Override
    public StringBuffer format(Object o, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Address address = (Address)o;
        String result = this.format;
        result = AddressFormat.replace(result, "%p", address.getPostcode());
        result = AddressFormat.replace(result, "%c", address.getCountry());
        result = AddressFormat.replace(result, "%s", address.getState());
        result = AddressFormat.replace(result, "%d", address.getDistrict());
        result = AddressFormat.replace(result, "%t", address.getSettlement());
        result = AddressFormat.replace(result, "%u", address.getSuburb());
        result = AddressFormat.replace(result, "%r", address.getStreet());
        result = AddressFormat.replace(result, "%h", address.getHouse());
        result = AddressFormat.replace(result, "%f", address.getFormattedAddress());
        result = result.replaceAll("^[, ]*", "");
        return stringBuffer.append(result);
    }

    @Override
    public Address parseObject(String s, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }
}

