/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.entities.AbstractExtendableRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedUser
extends AbstractExtendableRevisioned
implements InRealm {
    private final String realm;
    private final Long createdTimestamp;
    private final boolean emailVerified;
    private final boolean enabled;
    private final String federationLink;
    private final String serviceAccountClientLink;
    private final int notBefore;
    private final LazyLoader<UserModel, Set<String>> requiredActions;
    private final LazyLoader<UserModel, MultivaluedHashMap<String, String>> lazyLoadedAttributes;
    private final MultivaluedHashMap<String, String> eagerLoadedAttributes;
    private final LazyLoader<UserModel, Set<String>> roleMappings;
    private final LazyLoader<UserModel, Set<String>> groups;
    private final LazyLoader<UserModel, List<CredentialModel>> storedCredentials;

    public CachedUser(Long revision, RealmModel realm, UserModel user, int notBefore) {
        super(revision, user.getId());
        this.realm = realm.getId();
        this.createdTimestamp = user.getCreatedTimestamp();
        this.emailVerified = user.isEmailVerified();
        this.enabled = user.isEnabled();
        this.federationLink = user.getFederationLink();
        this.serviceAccountClientLink = user.getServiceAccountClientLink();
        this.notBefore = notBefore;
        this.eagerLoadedAttributes = new MultivaluedHashMap();
        this.eagerLoadedAttributes.putSingle((Object)"username", (Object)user.getUsername());
        this.eagerLoadedAttributes.putSingle((Object)"firstName", (Object)user.getFirstName());
        this.eagerLoadedAttributes.putSingle((Object)"lastName", (Object)user.getLastName());
        this.eagerLoadedAttributes.putSingle((Object)"email", (Object)user.getEmail());
        this.lazyLoadedAttributes = new DefaultLazyLoader<UserModel, MultivaluedHashMap>(userModel -> new MultivaluedHashMap(userModel.getAttributes()), MultivaluedHashMap::new);
        this.requiredActions = new DefaultLazyLoader<UserModel, Set>(userModel -> userModel.getRequiredActionsStream().collect(Collectors.toSet()), Collections::emptySet);
        this.roleMappings = new DefaultLazyLoader<UserModel, Set>(userModel -> userModel.getRoleMappingsStream().map(RoleModel::getId).collect(Collectors.toSet()), Collections::emptySet);
        this.groups = new DefaultLazyLoader<UserModel, Set>(userModel -> userModel.getGroupsStream().map(GroupModel::getId).collect(Collectors.toCollection(LinkedHashSet::new)), LinkedHashSet::new);
        this.storedCredentials = new DefaultLazyLoader<UserModel, List>(userModel -> userModel.credentialManager().getStoredCredentialsStream().collect(Collectors.toCollection(LinkedList::new)), LinkedList::new);
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public String getUsername() {
        return (String)this.eagerLoadedAttributes.getFirst((Object)"username");
    }

    public String getFirstAttribute(KeycloakSession session, String name, Supplier<UserModel> userModel) {
        if (this.eagerLoadedAttributes.containsKey((Object)name)) {
            return (String)this.eagerLoadedAttributes.getFirst((Object)name);
        }
        return (String)this.lazyLoadedAttributes.get(session, userModel).getFirst((Object)name);
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public String getEmail() {
        return (String)this.eagerLoadedAttributes.getFirst((Object)"email");
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MultivaluedHashMap<String, String> getAttributes(KeycloakSession session, Supplier<UserModel> userModel) {
        return this.lazyLoadedAttributes.get(session, userModel);
    }

    public Set<String> getRequiredActions(KeycloakSession session, Supplier<UserModel> userModel) {
        return this.requiredActions.get(session, userModel);
    }

    public Set<String> getRoleMappings(KeycloakSession session, Supplier<UserModel> userModel) {
        return this.roleMappings.get(session, userModel);
    }

    public String getFederationLink() {
        return this.federationLink;
    }

    public String getServiceAccountClientLink() {
        return this.serviceAccountClientLink;
    }

    public Set<String> getGroups(KeycloakSession session, Supplier<UserModel> userModel) {
        return this.groups.get(session, userModel);
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public List<CredentialModel> getStoredCredentials(KeycloakSession session, Supplier<UserModel> userModel) {
        return this.storedCredentials.get(session, userModel).stream().map(CredentialModel::shallowClone).collect(Collectors.toList());
    }
}

