/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.compatibility.ValueInterface;
import org.pentaho.di.core.Const;

public class ValueDate
implements ValueInterface,
Cloneable {
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private Date date;
    public int precision;

    public ValueDate() {
        this.date = null;
        this.precision = -1;
    }

    public ValueDate(Date date) {
        this.date = date;
        this.precision = -1;
    }

    public int getType() {
        return 3;
    }

    public String getTypeDesc() {
        return "Date";
    }

    public String getString() {
        if (this.date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(this.date);
    }

    public double getNumber() {
        if (this.date == null) {
            return 0.0;
        }
        return this.date.getTime();
    }

    public Date getDate() {
        return this.date;
    }

    public boolean getBoolean() {
        return false;
    }

    public long getInteger() {
        if (this.date == null) {
            return 0L;
        }
        return this.date.getTime();
    }

    public void setString(String string) {
        this.date = Const.toDate(string, null);
    }

    public void setSerializable(Serializable ser) {
    }

    public void setNumber(double number) {
        this.date = new Date((long)number);
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setBoolean(boolean bool) {
        this.date = null;
    }

    public void setInteger(long number) {
        this.date = new Date(number);
    }

    public int getLength() {
        return -1;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setLength(int length, int precision) {
        this.precision = precision;
    }

    public void setLength(int length) {
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public Object clone() {
        try {
            ValueDate retval = (ValueDate)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BigDecimal getBigNumber() {
        if (this.date == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(this.date.getTime());
    }

    public void setBigNumber(BigDecimal number) {
        this.setInteger(number.longValue());
    }

    public Serializable getSerializable() {
        return this.date;
    }

    public byte[] getBytes() {
        return null;
    }

    public void setBytes(byte[] b) {
    }
}

