/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.RIProductDescription;
import com.amazonaws.services.ec2.model.SpotInstanceState;
import com.amazonaws.services.ec2.model.SpotInstanceStateFault;
import com.amazonaws.services.ec2.model.SpotInstanceStatus;
import com.amazonaws.services.ec2.model.SpotInstanceType;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SpotInstanceRequest
implements Serializable {
    private String spotInstanceRequestId;
    private String spotPrice;
    private String type;
    private String state;
    private SpotInstanceStateFault fault;
    private SpotInstanceStatus status;
    private Date validFrom;
    private Date validUntil;
    private String launchGroup;
    private String availabilityZoneGroup;
    private LaunchSpecification launchSpecification;
    private String instanceId;
    private Date createTime;
    private String productDescription;
    private ListWithAutoConstructFlag<Tag> tags;
    private String launchedAvailabilityZone;

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public void setSpotInstanceRequestId(String spotInstanceRequestId) {
        this.spotInstanceRequestId = spotInstanceRequestId;
    }

    public SpotInstanceRequest withSpotInstanceRequestId(String spotInstanceRequestId) {
        this.spotInstanceRequestId = spotInstanceRequestId;
        return this;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public SpotInstanceRequest withSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SpotInstanceRequest withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(SpotInstanceType type) {
        this.type = type.toString();
    }

    public SpotInstanceRequest withType(SpotInstanceType type) {
        this.type = type.toString();
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public SpotInstanceRequest withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(SpotInstanceState state) {
        this.state = state.toString();
    }

    public SpotInstanceRequest withState(SpotInstanceState state) {
        this.state = state.toString();
        return this;
    }

    public SpotInstanceStateFault getFault() {
        return this.fault;
    }

    public void setFault(SpotInstanceStateFault fault) {
        this.fault = fault;
    }

    public SpotInstanceRequest withFault(SpotInstanceStateFault fault) {
        this.fault = fault;
        return this;
    }

    public SpotInstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(SpotInstanceStatus status) {
        this.status = status;
    }

    public SpotInstanceRequest withStatus(SpotInstanceStatus status) {
        this.status = status;
        return this;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public SpotInstanceRequest withValidFrom(Date validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public SpotInstanceRequest withValidUntil(Date validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public String getLaunchGroup() {
        return this.launchGroup;
    }

    public void setLaunchGroup(String launchGroup) {
        this.launchGroup = launchGroup;
    }

    public SpotInstanceRequest withLaunchGroup(String launchGroup) {
        this.launchGroup = launchGroup;
        return this;
    }

    public String getAvailabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public void setAvailabilityZoneGroup(String availabilityZoneGroup) {
        this.availabilityZoneGroup = availabilityZoneGroup;
    }

    public SpotInstanceRequest withAvailabilityZoneGroup(String availabilityZoneGroup) {
        this.availabilityZoneGroup = availabilityZoneGroup;
        return this;
    }

    public LaunchSpecification getLaunchSpecification() {
        return this.launchSpecification;
    }

    public void setLaunchSpecification(LaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
    }

    public SpotInstanceRequest withLaunchSpecification(LaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public SpotInstanceRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public SpotInstanceRequest withCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public SpotInstanceRequest withProductDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    public void setProductDescription(RIProductDescription productDescription) {
        this.productDescription = productDescription.toString();
    }

    public SpotInstanceRequest withProductDescription(RIProductDescription productDescription) {
        this.productDescription = productDescription.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public SpotInstanceRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public SpotInstanceRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getLaunchedAvailabilityZone() {
        return this.launchedAvailabilityZone;
    }

    public void setLaunchedAvailabilityZone(String launchedAvailabilityZone) {
        this.launchedAvailabilityZone = launchedAvailabilityZone;
    }

    public SpotInstanceRequest withLaunchedAvailabilityZone(String launchedAvailabilityZone) {
        this.launchedAvailabilityZone = launchedAvailabilityZone;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSpotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: " + this.getSpotInstanceRequestId() + ",");
        }
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: " + this.getSpotPrice() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getFault() != null) {
            sb.append("Fault: " + this.getFault() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getValidFrom() != null) {
            sb.append("ValidFrom: " + this.getValidFrom() + ",");
        }
        if (this.getValidUntil() != null) {
            sb.append("ValidUntil: " + this.getValidUntil() + ",");
        }
        if (this.getLaunchGroup() != null) {
            sb.append("LaunchGroup: " + this.getLaunchGroup() + ",");
        }
        if (this.getAvailabilityZoneGroup() != null) {
            sb.append("AvailabilityZoneGroup: " + this.getAvailabilityZoneGroup() + ",");
        }
        if (this.getLaunchSpecification() != null) {
            sb.append("LaunchSpecification: " + this.getLaunchSpecification() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: " + this.getCreateTime() + ",");
        }
        if (this.getProductDescription() != null) {
            sb.append("ProductDescription: " + this.getProductDescription() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getLaunchedAvailabilityZone() != null) {
            sb.append("LaunchedAvailabilityZone: " + this.getLaunchedAvailabilityZone());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSpotInstanceRequestId() == null ? 0 : this.getSpotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getFault() == null ? 0 : this.getFault().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getValidFrom() == null ? 0 : this.getValidFrom().hashCode());
        hashCode = 31 * hashCode + (this.getValidUntil() == null ? 0 : this.getValidUntil().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchGroup() == null ? 0 : this.getLaunchGroup().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZoneGroup() == null ? 0 : this.getAvailabilityZoneGroup().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecification() == null ? 0 : this.getLaunchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getProductDescription() == null ? 0 : this.getProductDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getLaunchedAvailabilityZone() == null ? 0 : this.getLaunchedAvailabilityZone().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotInstanceRequest)) {
            return false;
        }
        SpotInstanceRequest other = (SpotInstanceRequest)obj;
        if (other.getSpotInstanceRequestId() == null ^ this.getSpotInstanceRequestId() == null) {
            return false;
        }
        if (other.getSpotInstanceRequestId() != null && !other.getSpotInstanceRequestId().equals(this.getSpotInstanceRequestId())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getFault() == null ^ this.getFault() == null) {
            return false;
        }
        if (other.getFault() != null && !other.getFault().equals(this.getFault())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getValidFrom() == null ^ this.getValidFrom() == null) {
            return false;
        }
        if (other.getValidFrom() != null && !other.getValidFrom().equals(this.getValidFrom())) {
            return false;
        }
        if (other.getValidUntil() == null ^ this.getValidUntil() == null) {
            return false;
        }
        if (other.getValidUntil() != null && !other.getValidUntil().equals(this.getValidUntil())) {
            return false;
        }
        if (other.getLaunchGroup() == null ^ this.getLaunchGroup() == null) {
            return false;
        }
        if (other.getLaunchGroup() != null && !other.getLaunchGroup().equals(this.getLaunchGroup())) {
            return false;
        }
        if (other.getAvailabilityZoneGroup() == null ^ this.getAvailabilityZoneGroup() == null) {
            return false;
        }
        if (other.getAvailabilityZoneGroup() != null && !other.getAvailabilityZoneGroup().equals(this.getAvailabilityZoneGroup())) {
            return false;
        }
        if (other.getLaunchSpecification() == null ^ this.getLaunchSpecification() == null) {
            return false;
        }
        if (other.getLaunchSpecification() != null && !other.getLaunchSpecification().equals(this.getLaunchSpecification())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getProductDescription() == null ^ this.getProductDescription() == null) {
            return false;
        }
        if (other.getProductDescription() != null && !other.getProductDescription().equals(this.getProductDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getLaunchedAvailabilityZone() == null ^ this.getLaunchedAvailabilityZone() == null) {
            return false;
        }
        return other.getLaunchedAvailabilityZone() == null || other.getLaunchedAvailabilityZone().equals(this.getLaunchedAvailabilityZone());
    }
}

