/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.ProblemDefinition;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;

@NonNullApi
public class DefaultProblemDefinition
implements Serializable,
ProblemDefinition {
    private final ProblemId id;
    private final Severity severity;
    private final DocLink documentationLink;

    @VisibleForTesting
    DefaultProblemDefinition(ProblemId id, Severity severity, @Nullable DocLink documentationUrl) {
        this.id = id;
        this.severity = severity;
        this.documentationLink = documentationUrl;
    }

    @Override
    public ProblemId getId() {
        return this.id;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public DocLink getDocumentationLink() {
        return this.documentationLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblemDefinition that = (DefaultProblemDefinition)o;
        return this.severity == that.severity && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.documentationLink, (Object)that.documentationLink);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.severity, this.documentationLink});
    }

    public String toString() {
        return "DefaultProblemDefinition{id=" + this.id + ", severity=" + (Object)((Object)this.severity) + ", documentationLink=" + this.documentationLink + '}';
    }
}

