/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ssl;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ssl.OpaqueAuthenticationResult;
import org.apache.guacamole.auth.ssl.SSLAuthenticationSession;
import org.apache.guacamole.auth.ssl.SSLAuthenticationSessionManager;
import org.apache.guacamole.auth.ssl.conf.ConfigurationService;
import org.apache.guacamole.auth.sso.NonceService;
import org.apache.guacamole.auth.sso.SSOResource;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLClientAuthenticationResource
extends SSOResource {
    private static final String CLIENT_VERIFIED_HEADER_SUCCESS_VALUE = "SUCCESS";
    private static final String CLIENT_VERIFIED_HEADER_NONE_VALUE = "NONE";
    private static final String CLIENT_VERIFIED_HEADER_FAILED_PREFIX = "FAILED:";
    private static final Logger logger = LoggerFactory.getLogger(SSLClientAuthenticationResource.class);
    @Inject
    private ConfigurationService confService;
    @Inject
    private SSLAuthenticationSessionManager sessionManager;
    @Inject
    private NonceService subdomainNonceService;

    private String getHeader(HttpHeaders headers, String name) {
        List values = headers.getRequestHeader(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    private byte[] decode(String value) throws GuacamoleException {
        value = value.replace("+", "%2B");
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new GuacamoleClientException("Invalid URL-encoded value.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
    }

    public String getUsername(String name) throws GuacamoleException {
        LdapName dn;
        try {
            dn = new LdapName(name);
        }
        catch (InvalidNameException e) {
            throw new GuacamoleClientException("Subject \"" + name + "\" is not a valid DN: " + e.getMessage(), (Throwable)e);
        }
        int numComponents = dn.size();
        if (numComponents < 1) {
            throw new GuacamoleClientException("Subject DN is empty.");
        }
        LdapName baseDN = this.confService.getSubjectBaseDN();
        if (!(baseDN == null || numComponents > baseDN.size() && dn.startsWith(baseDN))) {
            throw new GuacamoleClientException("Subject DN \"" + dn + "\" is not within the configured base DN.");
        }
        Rdn nameRdn = dn.getRdn(numComponents - 1);
        Collection<String> usernameAttributes = this.confService.getSubjectUsernameAttributes();
        if (usernameAttributes != null) {
            if (!usernameAttributes.stream().anyMatch(nameRdn.getType()::equalsIgnoreCase)) {
                throw new GuacamoleClientException("Subject DN \"" + dn + "\" does not contain an acceptable username attribute.");
            }
        }
        String username = nameRdn.getValue().toString();
        logger.debug("Username \"{}\" extracted from subject DN \"{}\".", (Object)username, (Object)dn);
        return username;
    }

    public String getUsername(byte[] certificate) throws GuacamoleException {
        X509CertificateHolder cert;
        try (StringReader reader = new StringReader(new String(certificate, StandardCharsets.UTF_8));){
            PEMParser parser = new PEMParser((Reader)reader);
            Object object = parser.readObject();
            if (object == null || !(object instanceof X509CertificateHolder)) {
                throw new GuacamoleClientException("Certificate did not contain an X.509 certificate.");
            }
            if (parser.readObject() != null) {
                throw new GuacamoleClientException("Certificate contains more than a single X.509 certificate.");
            }
            cert = (X509CertificateHolder)object;
            if (!cert.isValidOn(new Date())) {
                throw new GuacamoleClientException("Certificate has expired.");
            }
        }
        catch (IOException e) {
            throw new GuacamoleServerException("Certificate could not be read: " + e.getMessage(), (Throwable)e);
        }
        X500Name subject = X500Name.getInstance((X500NameStyle)RFC4519Style.INSTANCE, (Object)cert.getSubject());
        return this.getUsername(subject.toString());
    }

    private String processCertificate(HttpHeaders headers) {
        try {
            String verified = this.getHeader(headers, this.confService.getClientVerifiedHeader());
            if (verified != null && verified.startsWith(CLIENT_VERIFIED_HEADER_FAILED_PREFIX)) {
                String message = verified.substring(CLIENT_VERIFIED_HEADER_FAILED_PREFIX.length());
                throw new GuacamoleClientException("Client certificate did not pass validation. SSL termination reports the following failure: \"" + message + "\"");
            }
            if (CLIENT_VERIFIED_HEADER_NONE_VALUE.equals(verified)) {
                throw new GuacamoleClientException("No client certificate was presented.");
            }
            if (!CLIENT_VERIFIED_HEADER_SUCCESS_VALUE.equals(verified)) {
                throw new GuacamoleClientException("Client certificate did not pass validation.");
            }
            String certificate = this.getHeader(headers, this.confService.getClientCertificateHeader());
            if (certificate == null) {
                throw new GuacamoleClientException("Client certificate missing from request.");
            }
            String username = this.getUsername(this.decode(certificate));
            long validityDuration = TimeUnit.MINUTES.toMillis(this.confService.getMaxTokenValidity());
            return this.sessionManager.defer(new SSLAuthenticationSession(username, validityDuration));
        }
        catch (GuacamoleClientException e) {
            logger.warn("SSL/TLS client authentication attempt rejected: {}", (Object)e.getMessage());
            logger.debug("SSL/TLS client authentication failed.", (Throwable)e);
        }
        catch (GuacamoleException e) {
            logger.error("SSL/TLS client authentication attempt could not be processed: {}", (Object)e.getMessage());
            logger.debug("SSL/TLS client authentication failed.", (Throwable)e);
        }
        catch (Error | RuntimeException e) {
            logger.error("SSL/TLS client authentication attempt failed internally: {}", (Object)e.getMessage());
            logger.debug("Internal failure processing SSL/TLS client authentication attempt.", e);
        }
        return this.sessionManager.generateInvalid();
    }

    @GET
    @Path(value="identity")
    public Response authenticateClient(@Context HttpHeaders headers, @HeaderParam(value="Host") String host) throws GuacamoleException {
        String subdomain = this.confService.getClientAuthenticationSubdomain(host);
        if (subdomain == null) {
            long validityDuration = TimeUnit.MINUTES.toMillis(this.confService.getMaxDomainValidity());
            String uniqueSubdomain = this.subdomainNonceService.generate(validityDuration);
            URI clientAuthURI = UriBuilder.fromUri((URI)this.confService.getClientAuthenticationURI(uniqueSubdomain)).path("api/ext/ssl/identity").build(new Object[0]);
            return Response.seeOther((URI)clientAuthURI).build();
        }
        if (this.subdomainNonceService.isValid(subdomain)) {
            return Response.ok((Object)new OpaqueAuthenticationResult(this.processCertificate(headers))).header("Access-Control-Allow-Origin", (Object)this.confService.getPrimaryOrigin().toString()).type("application/json").build();
        }
        throw new GuacamoleResourceNotFoundException("No such resource.");
    }
}

