/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.rrd4j.core.jrrd.RRDFile;

class UnivalArray {
    private final ByteBuffer buffer;
    private final int sizeoflong;

    public UnivalArray(RRDFile file, int size) {
        this.sizeoflong = file.getBits();
        this.buffer = ByteBuffer.allocate(size * 8);
        if (file.isBigEndian()) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        file.align();
        file.read(this.buffer);
    }

    public long getLong(Enum<?> e) {
        this.buffer.position(8 * e.ordinal());
        if (this.sizeoflong == 64) {
            return this.buffer.getLong();
        }
        return this.buffer.getInt();
    }

    public double getDouble(Enum<?> e) {
        this.buffer.position(8 * e.ordinal());
        return this.buffer.getDouble();
    }
}

