/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ThrowsTypeBlockingMethodChecker
implements BlockingMethodChecker {
    private static final Set<String> BLOCKING_EXCEPTION_TYPES = Set.of("java.lang.InterruptedException", "java.io.IOException");
    private static final Set<String> NON_BLOCKING_EXCEPTION_TYPES = Set.of("java.net.MalformedURLException");

    ThrowsTypeBlockingMethodChecker() {
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            ThrowsTypeBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isMethodBlocking(@NotNull MethodContext context) {
        if (context == null) {
            ThrowsTypeBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        if (!ThrowsTypeBlockingMethodChecker.isInStandardLibrary(context.getElement())) {
            return false;
        }
        for (PsiClassType throwType : context.getElement().getThrowsList().getReferencedTypes()) {
            PsiClass resolvedExceptionClass = throwType.resolve();
            if (resolvedExceptionClass == null) continue;
            for (String exceptionFqn : BLOCKING_EXCEPTION_TYPES) {
                if (!ThrowsTypeBlockingMethodChecker.isBlockingException(resolvedExceptionClass, exceptionFqn)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isBlockingException(PsiClass resolvedExceptionClass, String blockingFqn) {
        return InheritanceUtil.isInheritor((PsiClass)resolvedExceptionClass, (String)blockingFqn) && !NON_BLOCKING_EXCEPTION_TYPES.contains(resolvedExceptionClass.getQualifiedName());
    }

    private static boolean isInStandardLibrary(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String classQualifiedName = containingClass.getQualifiedName();
        return classQualifiedName != null && (classQualifiedName.startsWith("java.") || classQualifiedName.startsWith("javax.") || classQualifiedName.startsWith("jakarta."));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/ThrowsTypeBlockingMethodChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodBlocking";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

