/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.injection.Injectable;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaCompletionCustomizer;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaNestedCompletionsTreeProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonRequiredPropsReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaMetadataEntry;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaUsageTriggerCollector;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.impl.NotRequiredPropertiesKt;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import com.jetbrains.jsonSchema.impl.nestedCompletions.CompletionNextStep;
import com.jetbrains.jsonSchema.impl.nestedCompletions.NestedCompletionsKt;
import com.jetbrains.jsonSchema.impl.nestedCompletions.NestedCompletionsNode;
import com.jetbrains.jsonSchema.impl.nestedCompletions.NestedCompletionsNodeKt;
import com.jetbrains.jsonSchema.impl.nestedCompletions.SchemaPath;
import com.jetbrains.jsonSchema.impl.nestedCompletions.SchemaPathKt;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "skipForSchemaAndRef", "", "position", "Lcom/intellij/psi/PsiElement;", "service", "Lcom/jetbrains/jsonSchema/ide/JsonSchemaService;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Worker", "Companion", "intellij.json.backend"})
public final class JsonSchemaCompletionContributor
extends CompletionContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)position);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        JsonSchemaService service = JsonSchemaService.Impl.get(position.getProject());
        if (!service.isApplicableToFile(file)) {
            return;
        }
        JsonSchemaObject jsonSchemaObject = service.getSchemaObject(position.getContainingFile());
        if (jsonSchemaObject == null) {
            return;
        }
        JsonSchemaObject rootSchema = jsonSchemaObject;
        Intrinsics.checkNotNull((Object)service);
        if (this.skipForSchemaAndRef(position, service, file)) {
            return;
        }
        JsonSchemaCompletionContributor.Companion.updateStat(service.getSchemaProvider(rootSchema), service.resolveSchemaFile(rootSchema));
        Companion.doCompletion(parameters, result, rootSchema, true);
    }

    private final boolean skipForSchemaAndRef(PsiElement position, JsonSchemaService service, VirtualFile file) {
        PsiElement psiElement = position.getParent();
        if (psiElement == null) {
            return false;
        }
        PsiElement positionParent = psiElement;
        PsiElement psiElement2 = positionParent.getParent();
        JsonProperty jsonProperty = psiElement2 instanceof JsonProperty ? (JsonProperty)psiElement2 : null;
        if (jsonProperty == null) {
            return false;
        }
        JsonProperty parent = jsonProperty;
        String string = parent.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String propName = string;
        return Intrinsics.areEqual((Object)"$schema", (Object)propName) && parent.getParent() instanceof JsonObject && parent.getParent().getParent() instanceof JsonFile || Intrinsics.areEqual((Object)"$ref", (Object)propName) && service.isSchemaFile(file);
    }

    @JvmStatic
    public static final void doCompletion(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull JsonSchemaObject rootSchema, boolean stop) {
        Companion.doCompletion(parameters, result, rootSchema, stop);
    }

    @JvmStatic
    @NotNull
    public static final List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull CompletionType completionType) {
        return Companion.getCompletionVariants(schema, position, originalPosition, completionType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001c\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0013H\u0002JL\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000f2\u0006\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020\r2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/J\"\u00100\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0002JT\u00101\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u00102\u001a\u0004\u0018\u00010*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000f2\b\u00103\u001a\u0004\u0018\u00010(2\u0006\u00104\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u00105\u001a\u00020\rH\u0002J\u0016\u00106\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u00107\u001a\u000208\u00a8\u00069"}, d2={"Lcom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Companion;", "", "<init>", "()V", "doCompletion", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "rootSchema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "stop", "", "getCompletionVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "schema", "position", "Lcom/intellij/psi/PsiElement;", "originalPosition", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "updateStat", "provider", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "schemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "invokeEnterHandler", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleInsideQuotesInsertion", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "insideStringLiteral", "handleIncompleteString", "element", "createPropertyInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "finalType", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "defaultValueAsString", "", "values", "walker", "Lcom/jetbrains/jsonSchema/extension/JsonLikePsiWalker;", "completionPath", "Lcom/jetbrains/jsonSchema/impl/nestedCompletions/SchemaPath;", "findLeafAtCaret", "insertPropertyWithEnum", "defaultValue", "type", "comma", "insertColon", "formatInsertedString", "offset", "", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\nJsonSchemaCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaCompletionContributor.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,909:1\n1740#2,3:910\n1#3:913\n*S KotlinDebug\n*F\n+ 1 JsonSchemaCompletionContributor.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Companion\n*L\n857#1:910,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void doCompletion(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull JsonSchemaObject rootSchema, boolean stop) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)rootSchema, (String)"rootSchema");
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            PsiElement psiElement2 = parameters.getOriginalPosition();
            if (psiElement2 == null) {
                PsiElement psiElement3 = parameters.getPosition();
                psiElement2 = psiElement3;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getPosition(...)");
            }
            CompletionType completionType = parameters.getCompletionType();
            Intrinsics.checkNotNullExpressionValue((Object)completionType, (String)"getCompletionType(...)");
            Worker worker = new Worker(rootSchema, psiElement, psiElement2, completionType, (Function1<? super Collection<? extends LookupElement>, Unit>)((Function1)arg_0 -> Companion.doCompletion$lambda$0(result, arg_0)));
            worker.work();
            if (stop && !worker.getCompletionVariants().isEmpty()) {
                result.stopHere();
            }
        }

        @JvmStatic
        @NotNull
        public final List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull CompletionType completionType) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)originalPosition, (String)"originalPosition");
            Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
            List result = new ArrayList();
            new Worker(schema, position, originalPosition, completionType, (Function1<? super Collection<? extends LookupElement>, Unit>)((Function1)arg_0 -> Companion.getCompletionVariants$lambda$0(result, arg_0))).work();
            return result;
        }

        private final void updateStat(JsonSchemaFileProvider provider, VirtualFile schemaFile) {
            if (provider == null) {
                if (schemaFile instanceof HttpVirtualFile) {
                    JsonSchemaUsageTriggerCollector.trigger("remote");
                }
                return;
            }
            SchemaType schemaType = provider.getSchemaType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)schemaType), (String)"getSchemaType(...)");
            SchemaType schemaType2 = schemaType;
            JsonSchemaUsageTriggerCollector.trigger(switch (WhenMappings.$EnumSwitchMapping$0[schemaType2.ordinal()]) {
                case 1 -> "schema";
                case 2 -> "user";
                case 3 -> "builtin";
                case 4 -> "remote";
                default -> throw new NoWhenBranchMatchedException();
            });
        }

        private final void invokeEnterHandler(Editor editor) {
            EditorActionHandler handler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
            Caret caret = editor.getCaretModel().getCurrentCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
            Caret caret2 = caret;
            handler.execute(editor, caret2, EditorActionHandler.caretDataContext((DataContext)DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), (Caret)caret2));
        }

        private final boolean handleInsideQuotesInsertion(InsertionContext context, Editor editor, boolean insideStringLiteral) {
            JsonLikePsiWalker walker;
            if (!insideStringLiteral) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = context.getFile().findElementAt(offset);
            int tailOffset = context.getTailOffset();
            int guessEndOffset = tailOffset + 1;
            if (element instanceof LeafPsiElement) {
                if (this.handleIncompleteString(editor, element)) {
                    return false;
                }
                int endOffset = ((LeafPsiElement)element).getTextRange().getEndOffset();
                if (endOffset > tailOffset) {
                    context.getDocument().deleteString(tailOffset, endOffset - 1);
                }
            }
            if (element != null && (walker = JsonLikePsiWalker.getWalker(element)) != null && walker.isPropertyWithValue(walker.findElementToCheck(element))) {
                return true;
            }
            editor.getCaretModel().moveToOffset(guessEndOffset);
            return false;
        }

        private final boolean handleIncompleteString(Editor editor, PsiElement element) {
            PsiElement prevSibling;
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafPsiElement");
            if (((LeafPsiElement)element).getElementType() == TokenType.WHITE_SPACE && (prevSibling = ((LeafPsiElement)element).getPrevSibling()) instanceof JsonProperty) {
                JsonValue jsonValue = ((JsonProperty)prevSibling).getNameElement();
                Intrinsics.checkNotNullExpressionValue((Object)jsonValue, (String)"getNameElement(...)");
                JsonValue nameElement = jsonValue;
                String string = nameElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.endsWith$default((String)string, (String)"\"", (boolean)false, (int)2, null)) {
                    editor.getCaretModel().moveToOffset(nameElement.getTextRange().getEndOffset());
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\"", (boolean)false, (boolean)true, (int)1);
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final InsertHandler<LookupElement> createPropertyInsertHandler(@Nullable JsonSchemaType finalType, @Nullable String defaultValueAsString, @Nullable List<? extends Object> values, @NotNull JsonLikePsiWalker walker, boolean insideStringLiteral, @Nullable SchemaPath completionPath) {
            Intrinsics.checkNotNullParameter((Object)walker, (String)"walker");
            return (arg_0, arg_1) -> Companion.createPropertyInsertHandler$lambda$0(completionPath, insideStringLiteral, walker, finalType, defaultValueAsString, values, arg_0, arg_1);
        }

        public static /* synthetic */ InsertHandler createPropertyInsertHandler$default(Companion companion, JsonSchemaType jsonSchemaType, String string, List list, JsonLikePsiWalker jsonLikePsiWalker, boolean bl, SchemaPath schemaPath, int n, Object object) {
            if ((n & 0x20) != 0) {
                schemaPath = null;
            }
            return companion.createPropertyInsertHandler(jsonSchemaType, string, list, jsonLikePsiWalker, bl, schemaPath);
        }

        private final PsiElement findLeafAtCaret(InsertionContext context, Editor editor, JsonLikePsiWalker walker) {
            PsiElement psiElement;
            PsiElement psiElement2 = context.getFile().findElementAt(editor.getCaretModel().getOffset());
            if (psiElement2 != null) {
                PsiElement it = psiElement2;
                boolean bl = false;
                psiElement = NestedCompletionsKt.rewindToMeaningfulLeaf(it);
            } else {
                psiElement = null;
            }
            return psiElement;
        }

        /*
         * Unable to fully structure code
         */
        private final void insertPropertyWithEnum(InsertionContext context, Editor editor, String defaultValue, List<? extends Object> values, JsonSchemaType type, String comma, JsonLikePsiWalker walker, boolean insertColon) {
            block16: {
                value = defaultValue;
                propertyValueSeparator = walker.getPropertyValueSeparator(type);
                if (!walker.requiresValueQuotes() && value != null) {
                    value = StringUtil.unquoteString((String)value);
                }
                if (type != null && (JsonSchemaType._integer == type || JsonSchemaType._number == type)) ** GOTO lbl-1000
                if (type != null) ** GOTO lbl-1000
                if (value == null || StringUtil.isQuotedString((String)value)) {
                    if (values != null) {
                        block15: {
                            $this$all$iv = values;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                v0 = true;
                            } else {
                                var14_14 = $this$all$iv.iterator();
                                while (var14_14.hasNext()) {
                                    it = element$iv = var14_14.next();
                                    $i$a$-all-JsonSchemaCompletionContributor$Companion$insertPropertyWithEnum$isNumber$1 = false;
                                    if (it instanceof String == false) continue;
                                    v0 = false;
                                    break block15;
                                }
                                v0 = true;
                            }
                        }
                        ** if (!v0) goto lbl-1000
                    } else {
                        ** GOTO lbl25
                    }
                }
                ** GOTO lbl-1000
lbl25:
                // 2 sources

                ** GOTO lbl-1000
lbl-1000:
                // 3 sources

                {
                    v1 = true;
                    ** GOTO lbl29
                }
lbl-1000:
                // 3 sources

                {
                    v1 = false;
                }
lbl29:
                // 2 sources

                isNumber = v1;
                hasValues = ContainerUtil.isEmpty((Collection)values) == false;
                hasDefaultValue = StringUtil.isEmpty((String)value) == false;
                requiresQuotes = isNumber == false && walker.requiresValueQuotes() != false;
                offset = editor.getCaretModel().getOffset();
                v2 = editor.getDocument().getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCharsSequence(...)");
                charSequence = v2;
                ws = charSequence.length() > offset && charSequence.charAt(offset) == ' ' ? "" : " ";
                v3 = colonWs = insertColon != false ? propertyValueSeparator + ws : ws;
                stringToInsert = colonWs + (hasDefaultValue != false ? value : (requiresQuotes != false ? "\"\"" : "")) + comma;
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(insertColon != false ? propertyValueSeparator.length() + 1 : 1));
                if (!requiresQuotes && !hasDefaultValue) break block16;
                v4 = editor.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getSelectionModel(...)");
                model = v4;
                caretStart = model.getSelectionStart();
                if (caretStart - 1 < 0) ** GOTO lbl-1000
                it = editor.getDocument().getCharsSequence().charAt(caretStart - 1);
                $i$a$-let-JsonSchemaCompletionContributor$Companion$insertPropertyWithEnum$quoteOffset$1 = false;
                v5 = it == '\"' || it == '\'';
                if (v5) {
                    v6 = 0;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = quoteOffset = 1;
                }
                if (hasDefaultValue) {
                    v7 = value;
                    Intrinsics.checkNotNull((Object)v7);
                    v8 = v7.length();
                } else {
                    v8 = quoteOffset;
                }
                newOffset = caretStart + v8;
                if (hasDefaultValue && requiresQuotes) {
                    --newOffset;
                }
                model.setSelection(requiresQuotes != false ? caretStart + quoteOffset : caretStart, newOffset);
                editor.getCaretModel().moveToOffset(newOffset);
            }
            if (!walker.hasWhitespaceDelimitedCodeBlocks() && !Intrinsics.areEqual((Object)stringToInsert, (Object)(colonWs + comma))) {
                this.formatInsertedString(context, stringToInsert.length());
            }
            if (hasValues) {
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        }

        public final void formatInsertedString(@NotNull InsertionContext context, int offset) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiDocumentManager.getInstance((Project)project2).commitDocument(context.getDocument());
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
            codeStyleManager.reformatText(context.getFile(), context.getStartOffset(), context.getTailOffset() + offset);
        }

        private static final Unit doCompletion$lambda$0(CompletionResultSet $result, Collection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $result.addAllElements((Iterable)it);
            return Unit.INSTANCE;
        }

        private static final Unit getCompletionVariants$lambda$0(List $result, Collection elements) {
            Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
            $result.addAll(elements);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final void createPropertyInsertHandler$lambda$0(SchemaPath $completionPath, boolean $insideStringLiteral, JsonLikePsiWalker $walker, JsonSchemaType $finalType, String $defaultValueAsString, List $values, InsertionContext context, LookupElement var7_7) {
            block29: {
                block28: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)var7_7, (String)"<unused var>");
                    ThreadingAssertions.assertWriteAccess();
                    v0 = context.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getEditor(...)");
                    editor = v0;
                    v1 = context.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                    project = v1;
                    NestedCompletionsKt.expandMissingPropertiesAndMoveCaret(context, $completionPath);
                    stringToInsert = null;
                    if (JsonSchemaCompletionContributor.Companion.handleInsideQuotesInsertion(context, editor, $insideStringLiteral)) {
                        return;
                    }
                    propertyValueSeparator = $walker.getPropertyValueSeparator($finalType);
                    v2 = leafAtCaret = JsonSchemaCompletionContributor.Companion.findLeafAtCaret(context, editor, $walker);
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-JsonSchemaCompletionContributor$Companion$createPropertyInsertHandler$1$insertComma$1 = false;
                        v3 = $walker.hasMissingCommaAfter(it);
                    } else {
                        v3 = false;
                    }
                    insertComma = v3;
                    comma = insertComma != false ? "," : "";
                    v4 = leafAtCaret;
                    v5 = insertColon = Intrinsics.areEqual((Object)propertyValueSeparator, (Object)(v4 != null ? v4.getText() : null)) == false;
                    if (leafAtCaret != null && !insertColon) {
                        editor.getCaretModel().moveToOffset(PsiTreeUtilKt.getEndOffset((PsiElement)leafAtCaret));
                    }
                    if ($finalType == null) break block28;
                    hadEnter = false;
                    switch (WhenMappings.$EnumSwitchMapping$1[$finalType.ordinal()]) {
                        case 1: {
                            if (insertColon) {
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(propertyValueSeparator + " "), (boolean)false, (boolean)true, (int)(propertyValueSeparator.length() + 1));
                            }
                            hadEnter = false;
                            invokeEnter = $walker.hasWhitespaceDelimitedCodeBlocks();
                            if (insertColon && invokeEnter) {
                                JsonSchemaCompletionContributor.Companion.invokeEnterHandler(editor);
                                hadEnter = true;
                            }
                            if (insertColon) {
                                stringToInsert = $walker.getDefaultObjectValue() + comma;
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(hadEnter != false ? 0 : 1));
                            }
                            if (hadEnter || !insertColon) {
                                EditorActionUtil.moveCaretToLineEnd((Editor)editor, (boolean)false, (boolean)false);
                            }
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                            if (!hadEnter && stringToInsert != null) {
                                JsonSchemaCompletionContributor.Companion.formatInsertedString(context, stringToInsert.length());
                            }
                            if (stringToInsert != null && !invokeEnter) {
                                JsonSchemaCompletionContributor.Companion.invokeEnterHandler(editor);
                                break;
                            }
                            break block29;
                        }
                        case 2: {
                            value = String.valueOf(Intrinsics.areEqual((Object)"true", (Object)$defaultValueAsString));
                            stringToInsert = (String)(insertColon != false ? propertyValueSeparator + " " : " ") + value + comma;
                            v6 = editor.getSelectionModel();
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getSelectionModel(...)");
                            model = v6;
                            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(stringToInsert.length() - comma.length()));
                            JsonSchemaCompletionContributor.Companion.formatInsertedString(context, stringToInsert.length());
                            start = editor.getSelectionModel().getSelectionStart();
                            model.setSelection(start - value.length(), start);
                            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
                            break;
                        }
                        case 3: {
                            if (insertColon) {
                                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)propertyValueSeparator, (boolean)false, (boolean)true, (int)propertyValueSeparator.length());
                            }
                            hadEnter = false;
                            v7 = JsonSchemaCompletionContributor.Companion.findLeafAtCaret(context, editor, $walker);
                            v8 /* !! */  = nextSibling = v7 != null ? v7.getNextSibling() : null;
                            if (insertColon && $walker.hasWhitespaceDelimitedCodeBlocks()) {
                                JsonSchemaCompletionContributor.Companion.invokeEnterHandler(editor);
                                hadEnter = true;
                            } else if (!(nextSibling instanceof PsiWhiteSpace)) {
                                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)" ", (boolean)false, (boolean)true, (int)1);
                            } else {
                                editor.getCaretModel().moveToOffset(PsiTreeUtilKt.getEndOffset((PsiElement)nextSibling));
                            }
                            if (insertColon) ** GOTO lbl86
                            v9 = JsonSchemaCompletionContributor.Companion.findLeafAtCaret(context, editor, $walker);
                            if (!Intrinsics.areEqual((Object)(v9 != null ? v9.getText() : null), (Object)$walker.getPropertyValueSeparator(null))) ** GOTO lbl89
lbl86:
                            // 2 sources

                            stringToInsert = $walker.getDefaultArrayValue() + comma;
                            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(hadEnter != false ? 0 : 1));
lbl89:
                            // 2 sources

                            if (hadEnter) {
                                EditorActionUtil.moveCaretToLineEnd((Editor)editor, (boolean)false, (boolean)false);
                            }
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                            if (stringToInsert != null && $walker.requiresReformatAfterArrayInsertion()) {
                                JsonSchemaCompletionContributor.Companion.formatInsertedString(context, stringToInsert.length());
                                break;
                            }
                            break block29;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            JsonSchemaCompletionContributor.Companion.insertPropertyWithEnum(context, editor, $defaultValueAsString, $values, $finalType, comma, $walker, insertColon);
                        }
                    }
                    break block29;
                }
                JsonSchemaCompletionContributor.Companion.insertPropertyWithEnum(context, editor, $defaultValueAsString, $values, null, comma, $walker, insertColon);
            }
        }

        public static final /* synthetic */ boolean access$handleInsideQuotesInsertion(Companion $this, InsertionContext context, Editor editor, boolean insideStringLiteral) {
            return $this.handleInsideQuotesInsertion(context, editor, insideStringLiteral);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[SchemaType.values().length];
                try {
                    nArray[SchemaType.schema.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SchemaType.userSchema.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SchemaType.embeddedSchema.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SchemaType.remoteSchema.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[JsonSchemaType.values().length];
                try {
                    nArray[JsonSchemaType._object.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._boolean.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._array.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._string.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._integer.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._number.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u0000 Y2\u00020\u0001:\u0001YBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010!\u001a\u00020\rJ.\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00142\b\u0010(\u001a\u0004\u0018\u00010)J\u000e\u0010*\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0003J>\u0010+\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-2\b\u0010.\u001a\u0004\u0018\u00010/2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00142\b\u0010(\u001a\u0004\u0018\u00010)J \u00100\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010)J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020'0-H\u0002J\u0010\u00103\u001a\u00020\r2\b\u00104\u001a\u0004\u0018\u000105J\u0006\u00106\u001a\u00020\rJ\u0006\u00107\u001a\u00020\rJ\u0016\u00108\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\u0006\u00104\u001a\u000205J\u000e\u00109\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0003J\u0010\u0010:\u001a\u00020\r2\b\u0010;\u001a\u0004\u0018\u00010'J(\u0010<\u001a\u00020\r2\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010>2\u0006\u00101\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010)JU\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020'2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010'2\u0012\b\u0002\u0010C\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F2\b\b\u0002\u0010G\u001a\u00020\u0011\u00a2\u0006\u0002\u0010HJ\u0018\u0010I\u001a\u00020\u00112\b\u0010@\u001a\u0004\u0018\u00010'2\u0006\u0010J\u001a\u00020\u0011J*\u0010K\u001a\u00020\r2\u0006\u0010@\u001a\u00020'2\u0006\u0010L\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010M\u001a\u0004\u0018\u00010NJ\u0014\u0010O\u001a\u00020P*\u00020P2\u0006\u0010G\u001a\u00020\u0011H\u0002J.\u0010Q\u001a\b\u0012\u0004\u0012\u00020\f0D2\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010S\u001a\u00020\u0003H\u0002J\u0012\u0010T\u001a\u0004\u0018\u00010'2\u0006\u0010S\u001a\u00020\u0003H\u0002J6\u0010U\u001a\b\u0012\u0004\u0012\u00020\f0D2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010V\u001a\u00020\u00112\u0010\b\u0002\u0010W\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010-H\u0002J\u001e\u0010X\u001a\b\u0012\u0004\u0012\u00020\f0D2\u0006\u0010L\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006Z"}, d2={"Lcom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker;", "", "rootSchema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "completionPsiElement", "Lcom/intellij/psi/PsiElement;", "originalPosition", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "resultHandler", "Lkotlin/Function1;", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "", "<init>", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInsight/completion/CompletionType;Lkotlin/jvm/functions/Function1;)V", "wrapInQuotes", "", "insideStringLiteral", "completionVariants", "", "getCompletionVariants", "()Ljava/util/Set;", "psiWalker", "Lcom/jetbrains/jsonSchema/extension/JsonLikePsiWalker;", "myProject", "Lcom/intellij/openapi/project/Project;", "completionCustomizer", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaCompletionCustomizer;", "getCompletionCustomizer", "()Lcom/jetbrains/jsonSchema/extension/JsonSchemaCompletionCustomizer;", "completionCustomizer$delegate", "Lkotlin/Lazy;", "work", "processSchema", "schema", "isName", "Lcom/intellij/util/ThreeState;", "knownNames", "", "completionPath", "Lcom/jetbrains/jsonSchema/impl/nestedCompletions/SchemaPath;", "addPropertyNameSchemaVariants", "addAllPropertyVariants", "forbiddenNames", "", "adapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonPropertyAdapter;", "suggestValues", "isSurelyValue", "getEnumItemsToSkip", "suggestSpecialValues", "type", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "addInjectedLanguageVariants", "addRequiredPropVariants", "suggestByType", "addPossibleStringValue", "addStringVariant", "defaultValueString", "suggestValuesForSchemaVariants", "list", "", "addValueVariant", "key", "description", "altText", "handler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "order", "", "deprecated", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInsight/completion/InsertHandler;Ljava/lang/Integer;Z)V", "shouldWrapInQuotes", "isValue", "addPropertyVariant", "jsonSchemaObject", "sourcePsiAdapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonValueAdapter;", "withDeprecation", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "choosePropertyInsertHandler", "variants", "schemaObject", "getDocumentationOrTypeName", "createDefaultPropertyInsertHandler", "hasEnumValues", "valueTypes", "createPropertyInsertHandler", "Companion", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\nJsonSchemaCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaCompletionContributor.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,909:1\n1869#2,2:910\n1869#2,2:912\n1563#2:915\n1634#2,3:916\n774#2:919\n865#2,2:920\n1563#2:922\n1634#2,3:923\n1869#2,2:926\n808#2,11:928\n1563#2:939\n1634#2,3:940\n1563#2:943\n1634#2,3:944\n774#2:947\n865#2,2:948\n1869#2,2:950\n295#2,2:952\n1563#2:954\n1634#2,3:955\n774#2:958\n865#2,2:959\n1#3:914\n*S KotlinDebug\n*F\n+ 1 JsonSchemaCompletionContributor.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker\n*L\n138#1:910,2\n195#1:912,2\n261#1:915\n261#1:916,3\n288#1:919\n288#1:920,2\n289#1:922\n289#1:923,3\n290#1:926,2\n306#1:928,11\n306#1:939\n306#1:940,3\n309#1:943\n309#1:944,3\n309#1:947\n309#1:948,2\n310#1:950,2\n417#1:952,2\n450#1:954\n450#1:955,3\n114#1:958\n114#1:959,2\n*E\n"})
    private static final class Worker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JsonSchemaObject rootSchema;
        @NotNull
        private final PsiElement completionPsiElement;
        @NotNull
        private final PsiElement originalPosition;
        @NotNull
        private final CompletionType completionType;
        @NotNull
        private final Function1<Collection<? extends LookupElement>, Unit> resultHandler;
        private final boolean wrapInQuotes;
        private final boolean insideStringLiteral;
        @NotNull
        private final Set<LookupElement> completionVariants;
        @Nullable
        private final JsonLikePsiWalker psiWalker;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Lazy completionCustomizer$delegate;
        @NotNull
        private static final Set<String> filteredByDefault;
        @NotNull
        private static final List<String> commonAbbreviations;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement completionPsiElement, @NotNull PsiElement originalPosition, @NotNull CompletionType completionType, @NotNull Function1<? super Collection<? extends LookupElement>, Unit> resultHandler) {
            Intrinsics.checkNotNullParameter((Object)rootSchema, (String)"rootSchema");
            Intrinsics.checkNotNullParameter((Object)completionPsiElement, (String)"completionPsiElement");
            Intrinsics.checkNotNullParameter((Object)originalPosition, (String)"originalPosition");
            Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
            Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
            this.rootSchema = rootSchema;
            this.completionPsiElement = completionPsiElement;
            this.originalPosition = originalPosition;
            this.completionType = completionType;
            this.resultHandler = resultHandler;
            this.completionVariants = new LinkedHashSet();
            Project project = this.originalPosition.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.myProject = project;
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(this.completionPsiElement, this.rootSchema);
            PsiElement positionParent = this.completionPsiElement.getParent();
            boolean isInsideQuotedString = positionParent != null && walker != null && walker.isQuotedString(positionParent);
            this.wrapInQuotes = !isInsideQuotedString;
            this.psiWalker = walker;
            this.insideStringLiteral = isInsideQuotedString;
            this.completionCustomizer$delegate = LazyKt.lazy(() -> Worker.completionCustomizer_delegate$lambda$0(this));
        }

        @NotNull
        public final Set<LookupElement> getCompletionVariants() {
            return this.completionVariants;
        }

        private final JsonSchemaCompletionCustomizer getCompletionCustomizer() {
            Lazy lazy = this.completionCustomizer$delegate;
            return (JsonSchemaCompletionCustomizer)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void work() {
            void $this$forEach$iv;
            if (this.psiWalker == null) {
                return;
            }
            PsiElement checkable = this.psiWalker.findElementToCheck(this.completionPsiElement);
            if (checkable == null) {
                return;
            }
            ThreeState isName = this.psiWalker.isName(checkable);
            JsonPointerPosition position = this.psiWalker.findPosition(checkable, isName == ThreeState.NO);
            if (position == null || position.isEmpty() && isName == ThreeState.NO) {
                return;
            }
            Set knownNames = new LinkedHashSet();
            PsiFile psiFile = this.originalPosition.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            NestedCompletionsNode nestedCompletionsNode = NestedCompletionsNodeKt.navigate(JsonSchemaNestedCompletionsTreeProvider.Companion.getNestedCompletionsData(psiFile), position);
            JsonPropertyAdapter jsonPropertyAdapter = this.psiWalker.getParentPropertyAdapter(this.completionPsiElement);
            JsonSchemaNodeExpansionRequest schemaExpansionRequest = new JsonSchemaNodeExpansionRequest(jsonPropertyAdapter != null ? jsonPropertyAdapter.getParentObject() : null, this.completionType == CompletionType.SMART);
            Iterable<JsonSchemaObject> iterable = new JsonSchemaResolver(this.myProject, this.rootSchema, position, schemaExpansionRequest).resolve();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"resolve(...)");
            iterable = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonSchemaObject schema = (JsonSchemaObject)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)schema);
                NestedCompletionsKt.collectNestedCompletions$default(schema, this.myProject, nestedCompletionsNode, null, (arg_0, arg_1) -> Worker.work$lambda$0$0(this, isName, knownNames, arg_0, arg_1), 4, null);
            }
            this.resultHandler.invoke(this.completionVariants);
        }

        public final void processSchema(@NotNull JsonSchemaObject schema, @NotNull ThreeState isName, @NotNull Set<String> knownNames, @Nullable SchemaPath completionPath) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)isName, (String)"isName");
            Intrinsics.checkNotNullParameter(knownNames, (String)"knownNames");
            if (isName != ThreeState.NO) {
                JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
                Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
                PsiElement completionOriginalPosition = NestedCompletionsKt.findChildBy(jsonLikePsiWalker, completionPath, this.originalPosition);
                PsiElement completionPosition = NestedCompletionsKt.findChildBy(this.psiWalker, completionPath, this.completionPsiElement);
                Set<String> properties = this.psiWalker.getPropertyNamesOfParentObject(completionOriginalPosition, completionPosition);
                JsonPropertyAdapter adapter = this.psiWalker.getParentPropertyAdapter(completionOriginalPosition);
                Intrinsics.checkNotNull(properties);
                Set forbiddenNames = SetsKt.plus(NotRequiredPropertiesKt.findPropertiesThatMustNotBePresent(schema, this.completionPsiElement, this.myProject, properties), (Iterable)properties);
                this.addAllPropertyVariants(schema, forbiddenNames, adapter, knownNames, completionPath);
                this.addPropertyNameSchemaVariants(schema);
            }
            if (isName != ThreeState.YES) {
                this.suggestValues(schema, isName == ThreeState.NO, completionPath);
            }
        }

        public final void addPropertyNameSchemaVariants(@NotNull JsonSchemaObject schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Object object = schema.getPropertyNamesSchema();
            if (object == null || (object = ((JsonSchemaObject)object).getEnum()) == null) {
                return;
            }
            Object anEnum = object;
            Iterator iterator = anEnum.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object o = iterator.next();
                if (!(o instanceof String)) continue;
                if (!this.shouldWrapInQuotes((String)o, false)) {
                    object2 = (String)o;
                } else {
                    object2 = this.psiWalker;
                    if (object2 == null || (object2 = object2.escapeInvalidIdentifier((String)o)) == null) {
                        String string = StringUtil.wrapWithDoubleQuote((String)((String)o));
                        object2 = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapWithDoubleQuote(...)");
                    }
                }
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)StringUtil.unquoteString((String)object2));
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(...)");
                this.completionVariants.add((LookupElement)lookupElementBuilder);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addAllPropertyVariants(@NotNull JsonSchemaObject schema, @NotNull Set<String> forbiddenNames, @Nullable JsonPropertyAdapter adapter, @NotNull Set<String> knownNames, @Nullable SchemaPath completionPath) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter(forbiddenNames, (String)"forbiddenNames");
            Intrinsics.checkNotNullParameter(knownNames, (String)"knownNames");
            AbstractStreamEx abstractStreamEx = StreamEx.of(schema.getPropertyNames()).filter(arg_0 -> Worker.addAllPropertyVariants$lambda$1(arg_0 -> Worker.addAllPropertyVariants$lambda$0(forbiddenNames, knownNames, adapter, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)abstractStreamEx, (String)"filter(...)");
            Iterable iterable = (Iterable)abstractStreamEx;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonSchemaObject propertySchema;
                String name = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)name);
                knownNames.add(name);
                if (schema.getPropertyByName(name) == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                JsonSchemaCompletionCustomizer jsonSchemaCompletionCustomizer = this.getCompletionCustomizer();
                if (jsonSchemaCompletionCustomizer != null ? !jsonSchemaCompletionCustomizer.acceptsPropertyCompletionItem(propertySchema, this.completionPsiElement) : false) continue;
                JsonPropertyAdapter jsonPropertyAdapter = adapter;
                this.addPropertyVariant(name, propertySchema, completionPath, jsonPropertyAdapter != null ? jsonPropertyAdapter.getNameValueAdapter() : null);
            }
        }

        public final void suggestValues(@NotNull JsonSchemaObject schema, boolean isSurelyValue, @Nullable SchemaPath completionPath) {
            block4: {
                block5: {
                    block6: {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                            this.suggestValuesForSchemaVariants(schema.getAnyOf(), isSurelyValue, completionPath);
                            this.suggestValuesForSchemaVariants(schema.getOneOf(), isSurelyValue, completionPath);
                            this.suggestValuesForSchemaVariants(schema.getAllOf(), isSurelyValue, completionPath);
                            if (schema.getEnum() == null || completionPath != null) break block3;
                            Map<String, Map<String, String>> metadata = schema.getEnumMetadata();
                            boolean isEnumOrderSensitive = Boolean.parseBoolean(schema.readChildNodeValue("x-intellij-enum-order-sensitive"));
                            List<Object> anEnum = schema.getEnum();
                            Set filtered = SetsKt.plus(filteredByDefault, (Iterable)this.getEnumItemsToSkip());
                            List<Object> list = anEnum;
                            Intrinsics.checkNotNull(list);
                            int n = ((Collection)list).size();
                            for (int i = 0; i < n; ++i) {
                                Map<String, String> valueMetadata;
                                String variant;
                                Object o = anEnum.get(i);
                                if (this.insideStringLiteral && !(o instanceof String) || filtered.contains(variant = o.toString()) || filtered.contains(StringUtil.unquoteString((String)variant))) continue;
                                Map<String, Map<String, String>> map = metadata;
                                Map<String, String> map2 = valueMetadata = map != null ? map.get(StringUtil.unquoteString((String)variant)) : null;
                                String description = map2 != null ? map2.get("description") : null;
                                Map<String, String> map3 = valueMetadata;
                                String deprecated = map3 != null ? map3.get("deprecationMessage") : null;
                                Integer order = isEnumOrderSensitive ? Integer.valueOf(i) : null;
                                JsonSchemaCompletionCustomizer jsonSchemaCompletionCustomizer = this.getCompletionCustomizer();
                                InsertHandler<LookupElement> handler = jsonSchemaCompletionCustomizer != null ? jsonSchemaCompletionCustomizer.createHandlerForEnumValue(schema, variant, this.completionPsiElement) : null;
                                boolean bl = deprecated != null;
                                Worker.addValueVariant$default(this, variant, description, null, handler, order, bl, 4, null);
                            }
                            break block4;
                        }
                        if (!isSurelyValue) break block5;
                        JsonSchemaType type = JsonSchemaObjectReadingUtils.guessType(schema);
                        this.suggestSpecialValues(type);
                        if (type == null) break block6;
                        this.suggestByType(schema, type);
                        break block4;
                    }
                    if (schema.getTypeVariants() == null) break block4;
                    Set<JsonSchemaType> set = schema.getTypeVariants();
                    Intrinsics.checkNotNull(set);
                    for (JsonSchemaType schemaType : set) {
                        Intrinsics.checkNotNull((Object)((Object)schemaType));
                        this.suggestByType(schema, schemaType);
                    }
                    break block4;
                }
                JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
                boolean bl = jsonLikePsiWalker != null ? jsonLikePsiWalker.hasObjectArrayAmbivalence() : false;
                if (!bl) break block4;
                JsonSchemaObject jsonSchemaObject = schema.getItemsSchema();
                if (jsonSchemaObject != null) {
                    JsonSchemaObject itemsSchema = jsonSchemaObject;
                    boolean bl2 = false;
                    this.suggestValues(itemsSchema, false, completionPath);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private final Set<String> getEnumItemsToSkip() {
            v0 = this.psiWalker;
            position = v0 != null ? v0.findPosition(this.psiWalker.findElementToCheck(this.completionPsiElement), false) : null;
            v1 = position;
            if (v1 == null || (v1 = v1.trimTail(1)) == null) ** GOTO lbl-1000
            it = v1;
            $i$a$-let-JsonSchemaCompletionContributor$Worker$getEnumItemsToSkip$containerSchema$1 = false;
            v1 = new JsonSchemaResolver(this.myProject, this.rootSchema, (JsonPointerPosition)it, null).resolve();
            if (v1 != null) {
                v2 = (JsonSchemaObject)CollectionsKt.singleOrNull((Iterable)v1);
            } else lbl-1000:
            // 2 sources

            {
                v2 = containerSchema = null;
            }
            if (this.psiWalker == null) ** GOTO lbl-1000
            v3 = containerSchema;
            v4 = v3 != null ? v3.isUniqueItems() : false;
            if (v4) {
                block7: {
                    for (Object it : PsiTreeUtilKt.parents((PsiElement)this.completionPsiElement, (boolean)false)) {
                        $i$a$-firstNotNullOfOrNull-JsonSchemaCompletionContributor$Worker$getEnumItemsToSkip$parentArray$1 = false;
                        v5 = this.psiWalker.createValueAdapter((PsiElement)it);
                        it = v5 != null ? v5.getAsArray() : null;
                        if (it == null) continue;
                        v6 = it;
                        break block7;
                    }
                    v6 = null;
                }
                v7 = parentArray = v6;
                v8 = v7 != null ? v7.getElements() : null;
                if (v8 == null) {
                    v8 = CollectionsKt.emptyList();
                }
                var4_9 = v8;
                $i$f$map = false;
                it = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_13 = (JsonValueAdapter)item$iv$iv;
                    var13_15 = destination$iv$iv;
                    $i$a$-map-JsonSchemaCompletionContributor$Worker$getEnumItemsToSkip$1 = false;
                    var13_15.add(StringUtil.unquoteString((String)it.getDelegate().getText()));
                }
                v9 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            } else lbl-1000:
            // 2 sources

            {
                v9 = SetsKt.emptySet();
            }
            return v9;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void suggestSpecialValues(@Nullable JsonSchemaType type) {
            JsonPropertyAdapter adapter;
            JsonPropertyAdapter propertyAdapter;
            block8: {
                if (!JsonSchemaVersion.isSchemaSchemaId(this.rootSchema.getId()) || type != JsonSchemaType._string) {
                    return;
                }
                JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
                Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
                JsonPropertyAdapter jsonPropertyAdapter = jsonLikePsiWalker.getParentPropertyAdapter(this.originalPosition);
                if (jsonPropertyAdapter == null) {
                    return;
                }
                propertyAdapter = jsonPropertyAdapter;
                String string = propertyAdapter.getName();
                if (string == null) return;
                switch (string.hashCode()) {
                    case -1710970781: {
                        if (string.equals("x-intellij-language-injection")) break;
                        return;
                    }
                    case -1613589672: {
                        if (!string.equals("language")) {
                            return;
                        }
                        break block8;
                    }
                    case -393139297: {
                        if (!string.equals("required")) return;
                        this.addRequiredPropVariants();
                        return;
                    }
                }
                this.addInjectedLanguageVariants();
                return;
            }
            JsonObjectValueAdapter parent = propertyAdapter.getParentObject();
            if (parent == null || (adapter = this.psiWalker.getParentPropertyAdapter(parent.getDelegate())) == null || !Intrinsics.areEqual((Object)"x-intellij-language-injection", (Object)adapter.getName())) return;
            this.addInjectedLanguageVariants();
        }

        /*
         * WARNING - void declaration
         */
        public final void addInjectedLanguageVariants() {
            void $this$mapTo$iv$iv;
            Language it;
            Iterable $this$filterTo$iv$iv;
            JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
            Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
            PsiElement checkable = jsonLikePsiWalker.findElementToCheck(this.completionPsiElement);
            if (!(checkable instanceof JsonStringLiteral) && !(checkable instanceof JsonReferenceExpression)) {
                return;
            }
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Language)element$iv$iv;
                boolean bl = false;
                if (!LanguageUtil.isInjectableLanguage((Language)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Language)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(Injectable.fromLanguage((Language)it));
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Injectable it2 = (Injectable)element$iv;
                boolean bl = false;
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)it2.getId()).withIcon(it2.getIcon()).withTailText("(" + it2.getDisplayName() + ")", true);
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withTailText(...)");
                this.completionVariants.add((LookupElement)lookupElementBuilder);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addRequiredPropVariants() {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set set;
            Object it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Iterable $this$map$iv;
            boolean $i$f$map;
            Collection destination$iv$iv;
            JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
            Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
            PsiElement checkable = jsonLikePsiWalker.findElementToCheck(this.completionPsiElement);
            if (!(checkable instanceof JsonStringLiteral) && !(checkable instanceof JsonReferenceExpression)) {
                return;
            }
            JsonObject jsonObject = JsonRequiredPropsReferenceProvider.findPropertiesObject(checkable);
            if (jsonObject == null) {
                return;
            }
            JsonObject propertiesObject = jsonObject;
            PsiElement parent = ((JsonValue)checkable).getParent();
            if (parent instanceof JsonArray) {
                Iterable $this$filterIsInstanceTo$iv$iv;
                List list = ((JsonArray)parent).getValueList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueList(...)");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JsonStringLiteral)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    JsonStringLiteral jsonStringLiteral = (JsonStringLiteral)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getValue());
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            } else {
                set = SetsKt.emptySet();
            }
            Set items = set;
            List list = propertiesObject.getPropertyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyList(...)");
            $this$map$iv = list;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JsonProperty)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!items.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                this.addStringVariant(it2);
            }
        }

        public final void suggestByType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType type) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            if (JsonSchemaType._string == type) {
                this.addPossibleStringValue(schema);
            }
            if (this.insideStringLiteral) {
                return;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Worker.addValueVariant$default(this, "true", null, null, null, null, false, 62, null);
                    Worker.addValueVariant$default(this, "false", null, null, null, null, false, 62, null);
                    break;
                }
                case 2: {
                    Worker.addValueVariant$default(this, "null", null, null, null, null, false, 62, null);
                    break;
                }
                case 3: {
                    JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
                    Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
                    String value = jsonLikePsiWalker.getDefaultArrayValue();
                    Intrinsics.checkNotNull((Object)value);
                    Worker.addValueVariant$default(this, value, null, "[...]", Worker.Companion.createArrayOrObjectLiteralInsertHandler(this.psiWalker.hasWhitespaceDelimitedCodeBlocks(), value.length()), null, false, 50, null);
                    break;
                }
                case 4: {
                    JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
                    Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
                    String value = jsonLikePsiWalker.getDefaultObjectValue();
                    Intrinsics.checkNotNull((Object)value);
                    Worker.addValueVariant$default(this, value, null, "{...}", Worker.Companion.createArrayOrObjectLiteralInsertHandler(this.psiWalker.hasWhitespaceDelimitedCodeBlocks(), value.length()), null, false, 50, null);
                }
            }
        }

        public final void addPossibleStringValue(@NotNull JsonSchemaObject schema) {
            Object defaultValue;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Object object = defaultValue = schema.getDefault();
            String defaultValueString = object != null ? object.toString() : null;
            this.addStringVariant(defaultValueString);
        }

        public final void addStringVariant(@Nullable String defaultValueString) {
            if (defaultValueString == null) {
                return;
            }
            String normalizedValue = defaultValueString;
            JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
            Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
            boolean shouldQuote = jsonLikePsiWalker.requiresValueQuotes();
            boolean isQuoted = StringUtil.isQuotedString((String)normalizedValue);
            if (shouldQuote && !isQuoted) {
                String string = StringUtil.wrapWithDoubleQuote((String)normalizedValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapWithDoubleQuote(...)");
                normalizedValue = string;
            } else if (!shouldQuote && isQuoted) {
                String string = StringUtil.unquoteString((String)normalizedValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
                normalizedValue = string;
            }
            Worker.addValueVariant$default(this, normalizedValue, null, null, null, null, false, 62, null);
        }

        public final void suggestValuesForSchemaVariants(@Nullable List<? extends JsonSchemaObject> list, boolean isSurelyValue, @Nullable SchemaPath completionPath) {
            Collection collection = list;
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (JsonSchemaObject jsonSchemaObject : list) {
                this.suggestValues(jsonSchemaObject, isSurelyValue, completionPath);
            }
        }

        public final void addValueVariant(@NotNull String key, @Nullable String description, @Nullable String altText, @Nullable InsertHandler<LookupElement> handler, @Nullable Integer order, boolean deprecated) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = StringUtil.unquoteString((String)key);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
            String unquoted = string;
            String lookupString = !this.shouldWrapInQuotes(unquoted, true) ? unquoted : key;
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)lookupString);
            String string2 = altText;
            if (string2 == null) {
                string2 = lookupString;
            }
            LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.withPresentableText(string2).withTypeText(description).withInsertHandler(handler);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withInsertHandler(...)");
            LookupElementBuilder builder = this.withDeprecation(lookupElementBuilder2, deprecated);
            if (order != null) {
                LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)builder), (double)(-((double)order.intValue())));
                Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"withPriority(...)");
                v5 = this.completionVariants.add(lookupElement);
            } else {
                v5 = this.completionVariants.add((LookupElement)builder);
            }
        }

        public static /* synthetic */ void addValueVariant$default(Worker worker, String string, String string2, String string3, InsertHandler insertHandler, Integer n, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                string3 = null;
            }
            if ((n2 & 8) != 0) {
                insertHandler = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            worker.addValueVariant(string, string2, string3, (InsertHandler<LookupElement>)insertHandler, n, bl);
        }

        public final boolean shouldWrapInQuotes(@Nullable String key, boolean isValue) {
            return this.wrapInQuotes && this.psiWalker != null && (isValue && this.psiWalker.requiresValueQuotes() || !isValue && this.psiWalker.requiresNameQuotes() || key != null && !this.psiWalker.isValidIdentifier(key, this.myProject));
        }

        /*
         * Unable to fully structure code
         */
        public final void addPropertyVariant(@NotNull String key, @NotNull JsonSchemaObject jsonSchemaObject, @Nullable SchemaPath completionPath, @Nullable JsonValueAdapter sourcePsiAdapter) {
            block18: {
                block17: {
                    block16: {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)jsonSchemaObject, (String)"jsonSchemaObject");
                        propertyKey = key;
                        schemaObject = jsonSchemaObject;
                        v0 = new JsonSchemaResolver(this.myProject, schemaObject, new JsonPointerPosition(), sourcePsiAdapter).resolve();
                        Intrinsics.checkNotNullExpressionValue(v0, (String)"resolve(...)");
                        variants = v0;
                        v1 = ObjectUtils.coalesce((Object)CollectionsKt.firstOrNull((Iterable)variants), (Object)schemaObject);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"coalesce(...)");
                        schemaObject = (JsonSchemaObject)v1;
                        if (!this.shouldWrapInQuotes(propertyKey, false)) {
                            v2 = propertyKey;
                        } else {
                            v2 = this.psiWalker;
                            if (v2 == null || (v2 = v2.escapeInvalidIdentifier(propertyKey)) == null) {
                                v3 = StringUtil.wrapWithDoubleQuote((String)propertyKey);
                                v2 = v3;
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"wrapWithDoubleQuote(...)");
                            }
                        }
                        propertyKey = v2;
                        v4 = jsonSchemaObject.getMetadata();
                        if (v4 == null) ** GOTO lbl-1000
                        $this$firstOrNull$iv = v4;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (JsonSchemaMetadataEntry)element$iv;
                            $i$a$-firstOrNull-JsonSchemaCompletionContributor$Worker$addPropertyVariant$extraLookupStrings$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"aliases")) continue;
                            v5 = element$iv;
                            break block16;
                        }
                        v5 = null;
                    }
                    if ((v4 = (JsonSchemaMetadataEntry)v5) != null) {
                        v6 = v4.getValues();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = v7 = null;
                    }
                    if (v6 == null) {
                        v7 = CollectionsKt.emptyList();
                    }
                    extraLookupStrings = v7;
                    v8 = this;
                    v9 = LookupElementBuilder.create((String)propertyKey);
                    v10 = completionPath;
                    if (v10 == null) break block17;
                    var13_10 = v10;
                    var18_18 = v9;
                    var17_19 = v8;
                    $i$a$-let-JsonSchemaCompletionContributor$Worker$addPropertyVariant$builder$1 = false;
                    var19_20 = SchemaPathKt.prefix((SchemaPath)it) + "." + key;
                    v8 = var17_19;
                    v9 = var18_18;
                    v10 = var19_20;
                    if (var19_20 != null) break block18;
                }
                it = key;
                $i$a$-let-JsonSchemaCompletionContributor$Worker$addPropertyVariant$builder$1 = it;
                var18_18 = v9;
                var17_19 = v8;
                $i$a$-takeIf-JsonSchemaCompletionContributor$Worker$addPropertyVariant$builder$2 = false;
                v11 = this.psiWalker;
                var19_21 = v11 != null ? !v11.requiresNameQuotes() : false;
                v8 = var17_19;
                v9 = var18_18;
                v10 = var19_21 != false ? it : null;
                if (v10 == null) {
                    v10 = propertyKey;
                }
            }
            v12 = v9.withPresentableText((String)v10);
            v13 = var11_8 = new String[2];
            v14 = 0;
            v15 = completionPath;
            if (v15 != null) {
                it = v15;
                var20_22 = v14;
                var19_20 = v13;
                var18_18 = v12;
                var17_19 = v8;
                $i$a$-let-JsonSchemaCompletionContributor$Worker$addPropertyVariant$builder$3 = false;
                var21_23 = SchemaPathKt.prefix((SchemaPath)it) + "." + key;
                v8 = var17_19;
                v12 = var18_18;
                v13 = var19_20;
                v14 = var20_22;
                v16 = var21_23;
            } else {
                v16 = null;
            }
            v13[v14] = v16;
            var11_8[1] = propertyKey;
            v17 = CollectionsKt.listOfNotNull((Object[])var11_8);
            v18 = completionPath;
            v19 = v18 != null ? SchemaPathKt.accessor(v18) : null;
            if (v19 == null) {
                v19 = CollectionsKt.emptyList();
            }
            var10_24 = v12.withLookupStrings((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)v17, (Iterable)v19), (Iterable)extraLookupStrings)).withTypeText(this.getDocumentationOrTypeName(schemaObject), true).withIcon(Companion.access$getIcon(Worker.Companion, JsonSchemaObjectReadingUtils.guessType(schemaObject))).withInsertHandler(this.choosePropertyInsertHandler(completionPath, variants, schemaObject));
            Intrinsics.checkNotNullExpressionValue((Object)var10_24, (String)"withInsertHandler(...)");
            builder = v8.withDeprecation(var10_24, schemaObject.getDeprecationMessage() != null);
            if (completionPath != null) {
                v20 = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)builder), (double)(-((double)SchemaPathKt.accessor(completionPath).size())));
                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"withPriority(...)");
                v21 = this.completionVariants.add(v20);
            } else {
                v21 = this.completionVariants.add((LookupElement)builder);
            }
        }

        private final LookupElementBuilder withDeprecation(LookupElementBuilder $this$withDeprecation, boolean deprecated) {
            if (!deprecated) {
                return $this$withDeprecation;
            }
            LookupElementBuilder lookupElementBuilder = $this$withDeprecation.withTailText(JsonBundle.message((String)"schema.documentation.deprecated.postfix", (Object[])new Object[0]), true).withStrikeoutness(true);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withStrikeoutness(...)");
            return lookupElementBuilder;
        }

        /*
         * WARNING - void declaration
         */
        private final InsertHandler<LookupElement> choosePropertyInsertHandler(SchemaPath completionPath, Collection<? extends JsonSchemaObject> variants, JsonSchemaObject schemaObject) {
            Collection collection;
            if (Worker.Companion.hasSameType(variants)) {
                JsonSchemaType type = JsonSchemaObjectReadingUtils.guessType(schemaObject);
                List<Object> values = schemaObject.getEnum();
                Collection collection2 = values;
                if (!(collection2 == null || collection2.isEmpty())) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = values;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void v;
                        Object item$iv$iv;
                        Object t = item$iv$iv = iterator.next();
                        Collection collection3 = destination$iv$iv;
                        boolean bl = false;
                        collection3.add(v.getClass());
                    }
                    if (((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))).size() == 1) {
                        return this.createPropertyInsertHandler(schemaObject, completionPath);
                    }
                } else if (type != null || schemaObject.getDefault() != null) {
                    return this.createPropertyInsertHandler(schemaObject, completionPath);
                }
            }
            return this.createDefaultPropertyInsertHandler(completionPath, !((collection = (Collection)schemaObject.getEnum()) == null || collection.isEmpty()), schemaObject.getTypeVariants());
        }

        private final String getDocumentationOrTypeName(JsonSchemaObject schemaObject) {
            String string;
            String docText = JsonSchemaDocumentationProvider.getBestDocumentation(true, schemaObject);
            CharSequence charSequence = docText;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String string2 = StringUtil.removeHtmlTags((String)docText);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"removeHtmlTags(...)");
                string = Worker.Companion.findFirstSentence(string2);
            } else {
                string = JsonSchemaObjectReadingUtils.getTypeDescription(schemaObject, true);
            }
            return string;
        }

        private final InsertHandler<LookupElement> createDefaultPropertyInsertHandler(SchemaPath completionPath, boolean hasEnumValues, Set<? extends JsonSchemaType> valueTypes) {
            return (InsertHandler)new InsertHandler<LookupElement>(completionPath, this, hasEnumValues, valueTypes){
                final /* synthetic */ SchemaPath $completionPath;
                final /* synthetic */ Worker this$0;
                final /* synthetic */ boolean $hasEnumValues;
                final /* synthetic */ Set<JsonSchemaType> $valueTypes;
                {
                    this.$completionPath = $completionPath;
                    this.this$0 = $receiver;
                    this.$hasEnumValues = $hasEnumValues;
                    this.$valueTypes = $valueTypes;
                }

                /*
                 * Unable to fully structure code
                 */
                public void handleInsert(InsertionContext context, LookupElement item) {
                    block17: {
                        block16: {
                            block15: {
                                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                                ApplicationManager.getApplication().assertWriteAccessAllowed();
                                v0 = context.getEditor();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getEditor(...)");
                                editor = v0;
                                v1 = context.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                                project = v1;
                                NestedCompletionsKt.expandMissingPropertiesAndMoveCaret(context, this.$completionPath);
                                if (com.jetbrains.jsonSchema.impl.JsonSchemaCompletionContributor$Companion.access$handleInsideQuotesInsertion(JsonSchemaCompletionContributor.Companion, context, editor, Worker.access$getInsideStringLiteral$p(this.this$0))) {
                                    return;
                                }
                                v2 = Worker.access$getPsiWalker$p(this.this$0);
                                insertComma = v2 != null ? v2.hasMissingCommaAfter(Worker.access$getCompletionPsiElement$p(this.this$0)) : false;
                                v3 = comma = insertComma != false ? "," : "";
                                if (this.$hasEnumValues) ** GOTO lbl-1000
                                v4 = Worker.access$getPsiWalker$p(this.this$0);
                                if (v4 != null) {
                                    var9_7 = v4;
                                    var10_9 = this.this$0;
                                    it = var9_7;
                                    $i$a$-let-JsonSchemaCompletionContributor$Worker$createDefaultPropertyInsertHandler$1$handleInsert$hasValue$1 = false;
                                    v5 = it.isPropertyWithValue(it.findElementToCheck(Worker.access$getCompletionPsiElement$p(var10_9)));
                                } else {
                                    v5 = false;
                                }
                                if (v5) lbl-1000:
                                // 2 sources

                                {
                                    v6 = true;
                                } else {
                                    v6 = false;
                                }
                                hasValue = v6;
                                initialOffset = offset = editor.getCaretModel().getOffset();
                                v7 = context.getDocument().getCharsSequence();
                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getCharsSequence(...)");
                                docChars = v7;
                                while (offset < docChars.length() && Character.isWhitespace(docChars.charAt(offset))) {
                                    ++offset;
                                }
                                v8 = this.$valueTypes;
                                if (v8 == null) break block16;
                                var13_15 = v8;
                                var14_16 = this.this$0;
                                for (JsonSchemaType it : var13_15) {
                                    $i$a$-firstNotNullOfOrNull-JsonSchemaCompletionContributor$Worker$createDefaultPropertyInsertHandler$1$handleInsert$propertyValueSeparator$1 = false;
                                    v9 = Worker.access$getPsiWalker$p(var14_16);
                                    Intrinsics.checkNotNull((Object)v9);
                                    it = var18_20 = v9.getPropertyValueSeparator(it);
                                    $i$a$-takeIf-JsonSchemaCompletionContributor$Worker$createDefaultPropertyInsertHandler$1$handleInsert$propertyValueSeparator$1$1 = false;
                                    Intrinsics.checkNotNull((Object)it);
                                    var16_18 = !StringsKt.isBlank((CharSequence)it) ? var18_20 : null;
                                    if (var16_18 == null) continue;
                                    v10 = var16_18;
                                    break block15;
                                }
                                v10 = v8 = null;
                            }
                            if (v10 != null) break block17;
                        }
                        v11 = Worker.access$getPsiWalker$p(this.this$0);
                        Intrinsics.checkNotNull((Object)v11);
                        v12 = this.$valueTypes;
                        v8 = propertyValueSeparator = v11.getPropertyValueSeparator(v12 != null ? (JsonSchemaType)CollectionsKt.singleOrNull((Iterable)v12) : null);
                    }
                    if (hasValue) {
                        if (offset < docChars.length()) {
                            Intrinsics.checkNotNull((Object)propertyValueSeparator);
                            if (!this.isSeparatorAtOffset(docChars, offset, (String)propertyValueSeparator)) {
                                editor.getDocument().insertString(initialOffset, (CharSequence)propertyValueSeparator);
                                this.handleWhitespaceAfterColon(editor, docChars, initialOffset + propertyValueSeparator.length());
                            }
                        }
                        return;
                    }
                    if (offset >= docChars.length()) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)propertyValueSeparator);
                    if (this.isSeparatorAtOffset(docChars, offset, (String)propertyValueSeparator)) {
                        this.handleWhitespaceAfterColon(editor, docChars, offset + propertyValueSeparator.length());
                    } else lbl-1000:
                    // 2 sources

                    {
                        stringToInsert = (String)propertyValueSeparator + " 1" + comma;
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(propertyValueSeparator.length() + 1));
                        JsonSchemaCompletionContributor.Companion.formatInsertedString(context, stringToInsert.length());
                        offset = editor.getCaretModel().getOffset();
                        context.getDocument().deleteString(offset, offset + 1);
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
                }

                public final boolean isSeparatorAtOffset(CharSequence docChars, int offset, String propertyValueSeparator) {
                    Intrinsics.checkNotNullParameter((Object)docChars, (String)"docChars");
                    Intrinsics.checkNotNullParameter((Object)propertyValueSeparator, (String)"propertyValueSeparator");
                    return StringsKt.startsWith$default((String)((Object)docChars.subSequence(offset, docChars.length())).toString(), (String)propertyValueSeparator, (boolean)false, (int)2, null);
                }

                public final void handleWhitespaceAfterColon(Editor editor, CharSequence docChars, int nextOffset) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)docChars, (String)"docChars");
                    if (nextOffset < docChars.length() && docChars.charAt(nextOffset) == ' ') {
                        editor.getCaretModel().moveToOffset(nextOffset + 1);
                    } else {
                        editor.getCaretModel().moveToOffset(nextOffset);
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ", (boolean)false, (boolean)true, (int)1);
                    }
                }
            };
        }

        static /* synthetic */ InsertHandler createDefaultPropertyInsertHandler$default(Worker worker, SchemaPath schemaPath, boolean bl, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                schemaPath = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                set = null;
            }
            return worker.createDefaultPropertyInsertHandler(schemaPath, bl, set);
        }

        @NotNull
        public final InsertHandler<LookupElement> createPropertyInsertHandler(@NotNull JsonSchemaObject jsonSchemaObject, @Nullable SchemaPath completionPath) {
            String defaultValueAsString;
            Intrinsics.checkNotNullParameter((Object)jsonSchemaObject, (String)"jsonSchemaObject");
            Object defaultValue = jsonSchemaObject.getDefault();
            String string = defaultValueAsString = defaultValue == null || defaultValue instanceof JsonSchemaObject ? null : (defaultValue instanceof String ? "\"" + defaultValue + "\"" : defaultValue.toString());
            JsonSchemaType jsonSchemaType = JsonSchemaObjectReadingUtils.guessType(jsonSchemaObject);
            if (jsonSchemaType == null) {
                List list = jsonSchemaObject.getEnum();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                jsonSchemaType = Worker.Companion.detectTypeByEnumValues(list);
            }
            JsonSchemaType finalType = jsonSchemaType;
            List<Object> list = jsonSchemaObject.getEnum();
            JsonLikePsiWalker jsonLikePsiWalker = this.psiWalker;
            Intrinsics.checkNotNull((Object)jsonLikePsiWalker);
            return Companion.createPropertyInsertHandler(finalType, defaultValueAsString, list, jsonLikePsiWalker, this.insideStringLiteral, completionPath);
        }

        /*
         * WARNING - void declaration
         */
        private static final JsonSchemaCompletionCustomizer completionCustomizer_delegate$lambda$0(Worker this$0) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = JsonSchemaCompletionCustomizer.EXTENSION_POINT_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JsonSchemaCompletionCustomizer it = (JsonSchemaCompletionCustomizer)element$iv$iv;
                boolean bl = false;
                if (!it.isApplicable(this$0.originalPosition.getContainingFile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (JsonSchemaCompletionCustomizer)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        }

        private static final CompletionNextStep work$lambda$0$0(Worker this$0, ThreeState $isName, Set $knownNames, SchemaPath path, JsonSchemaObject subSchema) {
            CompletionNextStep completionNextStep;
            Intrinsics.checkNotNullParameter((Object)subSchema, (String)"subSchema");
            JsonSchemaCompletionCustomizer jsonSchemaCompletionCustomizer = this$0.getCompletionCustomizer();
            boolean bl = jsonSchemaCompletionCustomizer != null ? !jsonSchemaCompletionCustomizer.acceptsPropertyCompletionItem(subSchema, this$0.completionPsiElement) : false;
            if (bl) {
                completionNextStep = CompletionNextStep.Stop;
            } else {
                Intrinsics.checkNotNull((Object)$isName);
                this$0.processSchema(subSchema, $isName, $knownNames, path);
                completionNextStep = CompletionNextStep.Continue;
            }
            return completionNextStep;
        }

        private static final boolean addAllPropertyVariants$lambda$0(Set $forbiddenNames, Set $knownNames, JsonPropertyAdapter $adapter, String name) {
            return !$forbiddenNames.contains(name) && !$knownNames.contains(name) || $adapter != null && Intrinsics.areEqual((Object)name, (Object)$adapter.getName());
        }

        private static final boolean addAllPropertyVariants$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$getInsideStringLiteral$p(Worker $this) {
            return $this.insideStringLiteral;
        }

        public static final /* synthetic */ JsonLikePsiWalker access$getPsiWalker$p(Worker $this) {
            return $this.psiWalker;
        }

        public static final /* synthetic */ PsiElement access$getCompletionPsiElement$p(Worker $this) {
            return $this.completionPsiElement;
        }

        static {
            Object[] objectArray = new String[]{"[]", "{}", "[ ]", "{ }"};
            filteredByDefault = SetsKt.setOf((Object[])objectArray);
            objectArray = new String[]{"e.g.", "i.e."};
            commonAbbreviations = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker$Companion;", "", "<init>", "()V", "filteredByDefault", "", "", "commonAbbreviations", "", "findFirstSentence", "sentence", "getIcon", "Ljavax/swing/Icon;", "type", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "hasSameType", "", "variants", "", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "isUntypedEnum", "it", "createArrayOrObjectLiteralInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "newline", "insertedTextSize", "", "detectTypeByEnumValues", "values", "intellij.json.backend"})
        @SourceDebugExtension(value={"SMAP\nJsonSchemaCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaCompletionContributor.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,909:1\n2746#2,3:910\n1563#2:913\n1634#2,3:914\n*S KotlinDebug\n*F\n+ 1 JsonSchemaCompletionContributor.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker$Companion\n*L\n561#1:910,3\n584#1:913\n584#1:914,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final String findFirstSentence(String sentence) {
                int i = 0;
                i = StringsKt.indexOf$default((CharSequence)sentence, (String)". ", (int)0, (boolean)false, (int)6, null);
                while (i >= 0) {
                    boolean bl;
                    block5: {
                        Iterable $this$none$iv = commonAbbreviations;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                String abbr = (String)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.regionMatches$default((String)sentence, (int)(i - abbr.length() + 1), (String)abbr, (int)0, (int)abbr.length(), (boolean)false, (int)16, null)) continue;
                                bl = false;
                                break block5;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        String string = sentence.substring(0, i + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        return string;
                    }
                    i = StringsKt.indexOf$default((CharSequence)sentence, (String)". ", (int)(i + 1), (boolean)false, (int)4, null);
                }
                return sentence;
            }

            private final Icon getIcon(JsonSchemaType type) {
                Icon icon;
                if (type == null) {
                    return IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property);
                }
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        Icon icon2 = AllIcons.Json.Object;
                        icon = icon2;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Object");
                        break;
                    }
                    case 2: {
                        Icon icon3 = AllIcons.Json.Array;
                        icon = icon3;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Array");
                        break;
                    }
                    default: {
                        icon = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property);
                    }
                }
                return icon;
            }

            /*
             * WARNING - void declaration
             */
            private final boolean hasSameType(Collection<? extends JsonSchemaObject> variants) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = variants;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonSchemaObject jsonSchemaObject = (JsonSchemaObject)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Pair((Object)JsonSchemaObjectReadingUtils.guessType((JsonSchemaObject)it), (Object)Companion.isUntypedEnum((JsonSchemaObject)it)));
                }
                return ((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))).size() <= 1;
            }

            private final boolean isUntypedEnum(JsonSchemaObject it) {
                Collection collection;
                return JsonSchemaObjectReadingUtils.guessType(it) == null && !((collection = (Collection)it.getEnum()) == null || collection.isEmpty());
            }

            private final InsertHandler<LookupElement> createArrayOrObjectLiteralInsertHandler(boolean newline, int insertedTextSize) {
                return (arg_0, arg_1) -> Companion.createArrayOrObjectLiteralInsertHandler$lambda$0(newline, insertedTextSize, arg_0, arg_1);
            }

            private final JsonSchemaType detectTypeByEnumValues(List<? extends Object> values) {
                JsonSchemaType type = null;
                for (Object object : values) {
                    JsonSchemaType newType = null;
                    if (object instanceof Integer) {
                        newType = JsonSchemaType._integer;
                    }
                    if (type != null && type != newType) {
                        return null;
                    }
                    type = newType;
                }
                return type;
            }

            private static final void createArrayOrObjectLiteralInsertHandler$lambda$0(boolean $newline, int $insertedTextSize, InsertionContext context, LookupElement lookupElement) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
                Editor editor = context.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (!$newline) {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)-1);
                } else {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)(-$insertedTextSize));
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor2.getDocument());
                    JsonSchemaCompletionContributor.Companion.invokeEnterHandler(editor2);
                    EditorActionUtil.moveCaretToLineEnd((Editor)editor2, (boolean)false, (boolean)false);
                }
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(editor2);
            }

            public static final /* synthetic */ Icon access$getIcon(Companion $this, JsonSchemaType type) {
                return $this.getIcon(type);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[JsonSchemaType.values().length];
                    try {
                        nArray[JsonSchemaType._object.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[JsonSchemaType._array.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonSchemaType.values().length];
                try {
                    nArray[JsonSchemaType._boolean.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._null.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._array.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._object.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

