/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.Objects;
import java.util.concurrent.Flow;

public final class MultiSwitchOnEmptyOp<T>
extends AbstractMultiOperator<T, T> {
    private final Flow.Publisher<? extends T> alternative;

    public MultiSwitchOnEmptyOp(Multi<? extends T> upstream, Flow.Publisher<? extends T> alternative) {
        super(upstream);
        this.alternative = Objects.requireNonNull(alternative, "alternative");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        SwitchIfEmptySubscriber<? extends T> parent = new SwitchIfEmptySubscriber<T>(actual, this.alternative);
        actual.onSubscribe(parent);
        this.upstream.subscribe().withSubscriber(parent);
    }

    static final class SwitchIfEmptySubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Flow.Publisher<? extends T> alternative;
        boolean notEmpty;

        SwitchIfEmptySubscriber(MultiSubscriber<? super T> downstream, Flow.Publisher<? extends T> alternative) {
            super(downstream);
            this.alternative = alternative;
        }

        @Override
        public void onItem(T t) {
            if (!this.notEmpty) {
                this.notEmpty = true;
            }
            this.downstream.onItem(t);
        }

        @Override
        public void onCompletion() {
            if (!this.notEmpty) {
                this.notEmpty = true;
                this.alternative.subscribe(Infrastructure.onMultiSubscription(this.alternative, this));
            } else {
                this.downstream.onCompletion();
            }
        }
    }
}

