/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.infinispan;

import org.infinispan.Cache;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.keys.infinispan.InfinispanCachePublicKeyProvider;
import org.keycloak.keys.infinispan.PublicKeyStorageInvalidationEvent;
import org.keycloak.keys.infinispan.PublicKeysEntry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.CachePublicKeyProvider;
import org.keycloak.models.cache.CachePublicKeyProviderFactory;

public class InfinispanCachePublicKeyProviderFactory
implements CachePublicKeyProviderFactory {
    public static final String PROVIDER_ID = "infinispan";
    public static final String PUBLIC_KEY_STORAGE_INVALIDATION_EVENT = "PUBLIC_KEY_STORAGE_INVALIDATION_EVENT";
    public static final String KEYS_CLEAR_CACHE_EVENTS = "KEYS_CLEAR_CACHE_EVENTS";
    private volatile Cache<String, PublicKeysEntry> keysCache;

    public CachePublicKeyProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanCachePublicKeyProvider(session, this.keysCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.keysCache == null) {
            InfinispanCachePublicKeyProviderFactory infinispanCachePublicKeyProviderFactory = this;
            synchronized (infinispanCachePublicKeyProviderFactory) {
                if (this.keysCache == null) {
                    this.keysCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("keys");
                    ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
                    cluster.registerListener(PUBLIC_KEY_STORAGE_INVALIDATION_EVENT, event -> {
                        PublicKeyStorageInvalidationEvent invalidationEvent = (PublicKeyStorageInvalidationEvent)event;
                        this.keysCache.remove((Object)invalidationEvent.getCacheKey());
                    });
                    cluster.registerListener(KEYS_CLEAR_CACHE_EVENTS, event -> this.keysCache.clear());
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

