/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.detachable.DetachedCompositeNode;
import org.eclipse.xtext.nodemodel.detachable.DetachedLeafNode;
import org.eclipse.xtext.nodemodel.detachable.DetachedSyntheticCompositeNode;
import org.eclipse.xtext.nodemodel.detachable.GrammarElementLookup;
import org.eclipse.xtext.nodemodel.detachable.NodeModelReference;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.InternalNodeModelUtils;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.parser.AbstractParseResult;

public abstract class AbstractDetachableParseResult<NMR extends NodeModelReference, Serialized>
extends AbstractParseResult {
    private static final Logger logger = Logger.getLogger(AbstractDetachableParseResult.class);
    protected NodeModelReference reference;
    protected final GrammarElementLookup grammarElementLookup;
    protected final Stopwatch timer;
    protected final Duration timeout;
    protected final Executor releaser;
    protected CompletableFuture<Void> scheduled;

    protected AbstractDetachableParseResult(GrammarElementLookup grammarElementLookup) {
        this(grammarElementLookup, Duration.ofSeconds(5L));
    }

    protected AbstractDetachableParseResult(GrammarElementLookup grammarElementLookup, Duration timeout) {
        super(null, false);
        this.grammarElementLookup = grammarElementLookup;
        this.timer = Stopwatch.createUnstarted();
        this.timeout = timeout;
        this.releaser = CompletableFuture.delayedExecutor(timeout.toNanos(), TimeUnit.NANOSECONDS);
        this.scheduled = CompletableFuture.completedFuture(null);
    }

    @Override
    public ICompositeNode getRootNode() {
        return this.reference.rootNode();
    }

    @Override
    public void setRootNode(ICompositeNode rootNode) {
        throw new UnsupportedOperationException("Partial parsing is not supported");
    }

    public void releaseNodeModel(boolean now) {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
        if (now) {
            this.reference.release();
        } else {
            this.scheduleRelease();
        }
    }

    protected void discard() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"DetachableParseResultBase.discard");
        }
        this.timer.reset();
    }

    protected void nodeModelRequested() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"DetachableParseResultBase.nodeModelRequested");
        }
        this.timer.reset().start();
    }

    protected synchronized void scheduleRelease() {
        if (this.scheduled.isDone()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"DetachableParseResultBase.scheduleRelease");
            }
            this.scheduled = CompletableFuture.runAsync(() -> {
                NodeModelReference reference = this.reference;
                if (this.timer.isRunning() && reference != null) {
                    if (this.timer.elapsed().compareTo(this.timeout) > 0) {
                        reference.release();
                    } else {
                        this.scheduled.cancel(false);
                        this.scheduleRelease();
                    }
                }
            }, this.releaser);
        }
    }

    public ICompositeNode getNode(EObject semanticObject) {
        return this.reference.getNode(semanticObject);
    }

    protected void setRootNodeAndAssociations(ICompositeNode rootNode, Map<EObject, CompositeNodeWithSemanticElement> associations) {
        this.reference = this.toNodeModelReference(rootNode, associations);
    }

    protected abstract NMR toNodeModelReference(ICompositeNode var1, Map<EObject, CompositeNodeWithSemanticElement> var2);

    protected abstract Serialized serialize(NMR var1) throws IOException;

    protected abstract NMR deserialize(Serialized var1) throws IOException;

    @Override
    public Iterable<INode> getSyntaxErrors() {
        return Iterables.transform(super.getSyntaxErrors(), this::toExternalReference);
    }

    protected ILeafNode getLeafNode(int id) {
        return (ILeafNode)this.reference.getNode(id);
    }

    protected ICompositeNode getCompositeNode(int id) {
        return (ICompositeNode)this.reference.getNode(id);
    }

    protected GrammarElementLookup getGrammarElementLookup() {
        return this.grammarElementLookup;
    }

    protected INode toExternalReference(INode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof SyntheticCompositeNode) {
            SyntheticCompositeNode synthetic = (SyntheticCompositeNode)node;
            CompositeNode delegate = SyntheticCompositeNodeAccess.basicGetDelegate(synthetic);
            int delegateId = this.reference.getId(delegate);
            return new DetachedSyntheticCompositeNode(this, delegateId, SyntheticCompositeNodeAccess.basicGetGrammarElementIndex(synthetic));
        }
        if (node instanceof ILeafNode) {
            return new DetachedLeafNode(this, this.reference.getId(node));
        }
        return new DetachedCompositeNode(this, this.reference.getId(node));
    }

    private static class SyntheticCompositeNodeAccess
    extends InternalNodeModelUtils {
        private SyntheticCompositeNodeAccess() {
        }

        protected static CompositeNode basicGetDelegate(SyntheticCompositeNode node) {
            return InternalNodeModelUtils.basicGetDelegate(node);
        }

        protected static int basicGetGrammarElementIndex(SyntheticCompositeNode node) {
            return InternalNodeModelUtils.basicGetGrammarElementIndex(node);
        }
    }
}

