/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.internal.commands.AutomationCommand;
import org.openhab.core.automation.internal.commands.AutomationCommandsPluggable;

@NonNullByDefault
public class AutomationCommandExport
extends AutomationCommand {
    private static final String OPTION_P = "-p";
    private String parserType = "json";
    private @Nullable File file;
    private Locale locale = Locale.getDefault();

    public AutomationCommandExport(String command, String[] params, int providerType, AutomationCommandsPluggable autoCommands) {
        super(command, params, providerType, autoCommands);
    }

    @Override
    public String execute() {
        File file = this.file;
        if (!"SUCCESS".equals(this.parsingResult) || file == null) {
            return this.parsingResult;
        }
        HashSet<Rule> set = new HashSet<Rule>();
        switch (this.providerType) {
            case 3: {
                set.addAll(this.autoCommands.getTriggers(this.locale));
                set.addAll(this.autoCommands.getConditions(this.locale));
                set.addAll(this.autoCommands.getActions(this.locale));
                try {
                    return this.autoCommands.exportModuleTypes(this.parserType, set, file);
                }
                catch (Exception e) {
                    return this.getStackTrace(e);
                }
            }
            case 2: {
                set.addAll(this.autoCommands.getTemplates(this.locale));
                try {
                    return this.autoCommands.exportTemplates(this.parserType, set, file);
                }
                catch (Exception e) {
                    return this.getStackTrace(e);
                }
            }
            case 1: {
                set.addAll(this.autoCommands.getRules());
                try {
                    return this.autoCommands.exportRules(this.parserType, set, file);
                }
                catch (Exception e) {
                    return this.getStackTrace(e);
                }
            }
        }
        return String.format("%s : Unsupported provider type!", "FAIL");
    }

    private @Nullable File initFile(String parameterValue) {
        File f = new File(parameterValue);
        File parent = f.getParentFile();
        return parent == null || !parent.isDirectory() && !parent.mkdirs() ? null : f;
    }

    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        boolean getFile = true;
        int i = 0;
        while (i < parameterValues.length) {
            if (parameterValues[i] != null) {
                if ("-st".equals(parameterValues[i])) {
                    this.st = true;
                } else if (OPTION_P.equalsIgnoreCase(parameterValues[i])) {
                    if (++i >= parameterValues.length) {
                        return String.format("The option [%s] should be followed by value for the parser type.", OPTION_P);
                    }
                    this.parserType = parameterValues[i];
                } else {
                    if (parameterValues[i].charAt(0) == '-') {
                        return String.format("Unsupported option: %s", parameterValues[i]);
                    }
                    if (getFile) {
                        File file;
                        this.file = file = this.initFile(parameterValues[i]);
                        if (file != null) {
                            getFile = false;
                        }
                    } else {
                        return String.format("Unsupported parameter: %s", parameterValues[i]);
                    }
                }
            }
            ++i;
        }
        if (getFile) {
            return "Missing destination file parameter!";
        }
        return "SUCCESS";
    }
}

