"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ChatPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.ChatPluginSetup;
  }
});
Object.defineProperty(exports, "ChatPluginStart", {
  enumerable: true,
  get: function () {
    return _types.ChatPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _plugin = require("./plugin");
var _config = require("./config");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// This exports static code and TypeScript types,
// as well as, OpenSearch Dashboards Platform `plugin()` initializer.

const config = exports.config = {
  schema: _config.configSchema,
  exposeToBrowser: {
    enabled: true,
    agUiUrl: true
  }
};

/**
 * @experimental This plugin is experimental and will change in future releases.
 */
function plugin(initializerContext) {
  return new _plugin.ChatPlugin(initializerContext);
}