"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderLines = void 0;
var canvas_1 = require("../../../../renderers/canvas");
var utils_1 = require("../../rendering/utils");
var points_1 = require("./points");
var path_1 = require("./primitives/path");
var line_1 = require("./styles/line");
var panel_transform_1 = require("./utils/panel_transform");
function renderLines(ctx, props) {
    canvas_1.withContext(ctx, function (ctx) {
        var lines = props.lines, sharedStyle = props.sharedStyle, highlightedLegendItem = props.highlightedLegendItem, clippings = props.clippings, renderingArea = props.renderingArea, rotation = props.rotation;
        lines.forEach(function (_a) {
            var _b;
            var panel = _a.panel, line = _a.value;
            var seriesLineStyle = line.seriesLineStyle, seriesPointStyle = line.seriesPointStyle, points = line.points;
            if (seriesLineStyle.visible) {
                panel_transform_1.withPanelTransform(ctx, panel, rotation, renderingArea, function (ctx) {
                    renderLine(ctx, line, sharedStyle, clippings, highlightedLegendItem);
                }, { area: clippings, shouldClip: true });
            }
            var visiblePoints = seriesPointStyle.visible ? points : points.filter(function (_a) {
                var orphan = _a.orphan;
                return orphan;
            });
            if (visiblePoints.length === 0) {
                return;
            }
            var geometryStyle = utils_1.getGeometryStateStyle(line.seriesIdentifier, sharedStyle, highlightedLegendItem);
            panel_transform_1.withPanelTransform(ctx, panel, rotation, renderingArea, function (ctx) {
                points_1.renderPoints(ctx, visiblePoints, geometryStyle);
            }, { area: clippings, shouldClip: ((_b = line.points[0]) === null || _b === void 0 ? void 0 : _b.value.mark) !== null });
        });
    });
}
exports.renderLines = renderLines;
function renderLine(ctx, line, sharedStyle, clippings, highlightedLegendItem) {
    var color = line.color, transform = line.transform, seriesIdentifier = line.seriesIdentifier, seriesLineStyle = line.seriesLineStyle, clippedRanges = line.clippedRanges, hideClippedRanges = line.hideClippedRanges;
    var geometryStyle = utils_1.getGeometryStateStyle(seriesIdentifier, sharedStyle, highlightedLegendItem);
    var stroke = line_1.buildLineStyles(color, seriesLineStyle, geometryStyle);
    path_1.renderLinePaths(ctx, transform, [line.line], stroke, clippedRanges, clippings, hideClippedRanges);
}
//# sourceMappingURL=lines.js.map