"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@osd/config-schema");
var _metrics = require("./server/metrics");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  metrics: _configSchema.schema.object({
    metricInterval: _configSchema.schema.number({
      defaultValue: _metrics.METRIC_INTERVAL.ONE_MINUTE
    }),
    windowSize: _configSchema.schema.number({
      min: 2,
      max: 10,
      defaultValue: _metrics.DEFAULT_WINDOW_SIZE
    })
  })
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9tZXRyaWNzIiwiY29uZmlnU2NoZW1hIiwiZXhwb3J0cyIsInNjaGVtYSIsIm9iamVjdCIsIm1ldHJpY3MiLCJtZXRyaWNJbnRlcnZhbCIsIm51bWJlciIsImRlZmF1bHRWYWx1ZSIsIk1FVFJJQ19JTlRFUlZBTCIsIk9ORV9NSU5VVEUiLCJ3aW5kb3dTaXplIiwibWluIiwibWF4IiwiREVGQVVMVF9XSU5ET1dfU0laRSJdLCJzb3VyY2VzIjpbImNvbmZpZy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IHNjaGVtYSwgVHlwZU9mIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcblxuaW1wb3J0IHsgTUVUUklDX0lOVEVSVkFMLCBERUZBVUxUX1dJTkRPV19TSVpFIH0gZnJvbSAnLi9zZXJ2ZXIvbWV0cmljcyc7XG5cbmV4cG9ydCBjb25zdCBjb25maWdTY2hlbWEgPSBzY2hlbWEub2JqZWN0KHtcbiAgbWV0cmljczogc2NoZW1hLm9iamVjdCh7XG4gICAgbWV0cmljSW50ZXJ2YWw6IHNjaGVtYS5udW1iZXIoeyBkZWZhdWx0VmFsdWU6IE1FVFJJQ19JTlRFUlZBTC5PTkVfTUlOVVRFIH0pLFxuICAgIHdpbmRvd1NpemU6IHNjaGVtYS5udW1iZXIoeyBtaW46IDIsIG1heDogMTAsIGRlZmF1bHRWYWx1ZTogREVGQVVMVF9XSU5ET1dfU0laRSB9KSxcbiAgfSksXG59KTtcblxuZXhwb3J0IHR5cGUgU2VhcmNoUmVsZXZhbmNlUGx1Z2luQ29uZmlnVHlwZSA9IFR5cGVPZjx0eXBlb2YgY29uZmlnU2NoZW1hPjtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsYUFBQSxHQUFBQyxPQUFBO0FBRUEsSUFBQUMsUUFBQSxHQUFBRCxPQUFBO0FBUEE7QUFDQTtBQUNBO0FBQ0E7O0FBTU8sTUFBTUUsWUFBWSxHQUFBQyxPQUFBLENBQUFELFlBQUEsR0FBR0Usb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO0VBQ3hDQyxPQUFPLEVBQUVGLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztJQUNyQkUsY0FBYyxFQUFFSCxvQkFBTSxDQUFDSSxNQUFNLENBQUM7TUFBRUMsWUFBWSxFQUFFQyx3QkFBZSxDQUFDQztJQUFXLENBQUMsQ0FBQztJQUMzRUMsVUFBVSxFQUFFUixvQkFBTSxDQUFDSSxNQUFNLENBQUM7TUFBRUssR0FBRyxFQUFFLENBQUM7TUFBRUMsR0FBRyxFQUFFLEVBQUU7TUFBRUwsWUFBWSxFQUFFTTtJQUFvQixDQUFDO0VBQ2xGLENBQUM7QUFDSCxDQUFDLENBQUMifQ==