"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTitle = getTitle;
var _utils = require("../utils");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

async function getTitle(client, indexPatternId, dataSourceIdToTitle) {
  const savedObject = await client.get('index-pattern', indexPatternId);
  if (savedObject.error) {
    throw new Error(`Unable to get index-pattern title: ${savedObject.error.message}`);
  }
  const dataSourceReference = (0, _utils.getDataSourceReference)(savedObject.references);
  if (dataSourceReference) {
    const dataSourceId = dataSourceReference.id;
    if (dataSourceIdToTitle.has(dataSourceId)) {
      return (0, _utils.concatDataSourceWithIndexPattern)(dataSourceIdToTitle.get(dataSourceId), savedObject.attributes.title);
    }
  }
  const getDataSource = async id => await client.get('data-source', id);
  return (0, _utils.getIndexPatternTitle)(savedObject.attributes.title, savedObject.references, getDataSource);
}