/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec2(-10l, -12l) >> 0u) => i64vec2(-10l, -12l)
 * (i64vec2(-10l, -12l) >> 1u) => i64vec2(-5l, -6l)
 * (i64vec2(-10l, -12l) >> 2u) => i64vec2(-3l, -3l)
 * (i64vec2(-10l, -12l) >> 5u) => i64vec2(-1l, -1l)
 * (i64vec2(-10l, -12l) >> 25u) => i64vec2(-1l, -1l)
 * (i64vec2(-10l, -12l) >> 31u) => i64vec2(-1l, -1l)
 * (i64vec2(-42l, 48l) >> 0u) => i64vec2(-42l, 48l)
 * (i64vec2(-42l, 48l) >> 1u) => i64vec2(-21l, 24l)
 * (i64vec2(-42l, 48l) >> 2u) => i64vec2(-11l, 12l)
 * (i64vec2(-42l, 48l) >> 5u) => i64vec2(-2l, 1l)
 * (i64vec2(-42l, 48l) >> 25u) => i64vec2(-1l, 0l)
 * (i64vec2(-42l, 48l) >> 31u) => i64vec2(-1l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec2(-10l, -12l) >> 0u), i64vec2(-10l, -12l))) ? 1 : -1] array0;
  float[all(equal((i64vec2(-10l, -12l) >> 1u), i64vec2(-5l, -6l))) ? 1 : -1] array1;
  float[all(equal((i64vec2(-10l, -12l) >> 2u), i64vec2(-3l, -3l))) ? 1 : -1] array2;
  float[all(equal((i64vec2(-10l, -12l) >> 5u), i64vec2(-1l, -1l))) ? 1 : -1] array3;
  float[all(equal((i64vec2(-10l, -12l) >> 25u), i64vec2(-1l, -1l))) ? 1 : -1] array4;
  float[all(equal((i64vec2(-10l, -12l) >> 31u), i64vec2(-1l, -1l))) ? 1 : -1] array5;
  float[all(equal((i64vec2(-42l, 48l) >> 0u), i64vec2(-42l, 48l))) ? 1 : -1] array6;
  float[all(equal((i64vec2(-42l, 48l) >> 1u), i64vec2(-21l, 24l))) ? 1 : -1] array7;
  float[all(equal((i64vec2(-42l, 48l) >> 2u), i64vec2(-11l, 12l))) ? 1 : -1] array8;
  float[all(equal((i64vec2(-42l, 48l) >> 5u), i64vec2(-2l, 1l))) ? 1 : -1] array9;
  float[all(equal((i64vec2(-42l, 48l) >> 25u), i64vec2(-1l, 0l))) ? 1 : -1] array10;
  float[all(equal((i64vec2(-42l, 48l) >> 31u), i64vec2(-1l, 0l))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
