/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters.date;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Parser {
    public static List<String> datePatterns = new ArrayList<String>();

    public static ZonedDateTime parse(String str, Locale locale, ZoneId defaultZone) {
        for (String pattern : datePatterns) {
            try {
                DateTimeFormatter timeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(pattern).toFormatter(locale);
                TemporalAccessor temporalAccessor = timeFormatter.parse(str);
                return Parser.getZonedDateTimeFromTemporalAccessor(temporalAccessor, defaultZone);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static ZonedDateTime getZonedDateTimeFromTemporalAccessor(TemporalAccessor temporalAccessor, ZoneId defaultZone) {
        TemporalField[] copyThese;
        if (temporalAccessor instanceof ZonedDateTime) {
            return (ZonedDateTime)temporalAccessor;
        }
        LocalDateTime now = LocalDateTime.now();
        for (TemporalField tf : copyThese = new TemporalField[]{ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND}) {
            if (!temporalAccessor.isSupported(tf)) continue;
            now = now.with(tf, temporalAccessor.get(tf));
        }
        ZoneId zoneId = temporalAccessor.query(TemporalQueries.zone());
        if (zoneId == null) {
            zoneId = defaultZone;
        }
        return now.atZone(zoneId);
    }

    static {
        datePatterns.add("yyyy-MM-dd HH:mm:ss");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss");
        datePatterns.add("yyyy-MM-dd HH:mm:ss Z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss Z");
        datePatterns.add("yyyy-MM-dd HH:mm:ss X");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss X");
        datePatterns.add("yyyy-MM-dd HH:mm:ss z");
        datePatterns.add("yyyy-MM-dd'T'HH:mm:ss z");
        datePatterns.add("EEE MMM dd hh:mm:ss yyyy");
    }
}

