/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.Checksum;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;

public class Gt06ProtocolEncoder
extends BaseProtocolEncoder {
    public Gt06ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(long deviceId, String content) {
        boolean language = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_LANGUAGE.withPrefix(this.getProtocolName()), deviceId);
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(120);
        buf.writeByte(120);
        buf.writeByte(6 + content.length() + 2 + 2 + (language ? 2 : 0));
        buf.writeByte(128);
        buf.writeByte(4 + content.length());
        buf.writeInt(0);
        buf.writeBytes(content.getBytes(StandardCharsets.US_ASCII));
        if (language) {
            buf.writeShort(2);
        }
        buf.writeShort(0);
        buf.writeShort(Checksum.crc16(Checksum.CRC16_X25, buf.nioBuffer(2, buf.writerIndex() - 2)));
        buf.writeByte(13);
        buf.writeByte(10);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ALTERNATIVE.withPrefix(this.getProtocolName()), command.getDeviceId());
        String password = AttributeUtil.getDevicePassword(this.getCacheManager(), command.getDeviceId(), this.getProtocolName(), "123456");
        String model = this.getDeviceModel(command.getDeviceId());
        switch (command.getType()) {
            case "engineStop": {
                if ("G109".equals(model)) {
                    return this.encodeContent(command.getDeviceId(), "DYD#");
                }
                if (alternative) {
                    return this.encodeContent(command.getDeviceId(), "DYD," + password + "#");
                }
                return this.encodeContent(command.getDeviceId(), "Relay,1#");
            }
            case "engineResume": {
                if ("G109".equals(model)) {
                    return this.encodeContent(command.getDeviceId(), "HFYD#");
                }
                if (alternative) {
                    return this.encodeContent(command.getDeviceId(), "HFYD," + password + "#");
                }
                return this.encodeContent(command.getDeviceId(), "Relay,0#");
            }
            case "custom": {
                return this.encodeContent(command.getDeviceId(), command.getString("data"));
            }
        }
        return null;
    }
}

