/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;

public class ClaimValidationUtils {
    public static Set<String> validateScopes(String scopeClaimName, Collection<String> scopes) throws JwtValidatorException {
        if (scopes == null) {
            throw new JwtValidatorException(String.format("%s value must be non-null", scopeClaimName));
        }
        HashSet<String> copy = new HashSet<String>();
        for (String scope : scopes) {
            if (copy.contains(scope = ClaimValidationUtils.validateString(scopeClaimName, scope))) {
                throw new JwtValidatorException(String.format("%s value must not contain duplicates - %s already present", scopeClaimName, scope));
            }
            copy.add(scope);
        }
        return Collections.unmodifiableSet(copy);
    }

    public static long validateExpiration(String claimName, Long claimValue) throws JwtValidatorException {
        if (claimValue == null) {
            throw new JwtValidatorException(String.format("%s value must be non-null", claimName));
        }
        if (claimValue < 0L) {
            throw new JwtValidatorException(String.format("%s value must be non-negative; value given was \"%s\"", claimName, claimValue));
        }
        return claimValue;
    }

    public static String validateSubject(String claimName, String claimValue) throws JwtValidatorException {
        return ClaimValidationUtils.validateString(claimName, claimValue);
    }

    public static Long validateIssuedAt(String claimName, Long claimValue) throws JwtValidatorException {
        if (claimValue != null && claimValue < 0L) {
            throw new JwtValidatorException(String.format("%s value must be null or non-negative; value given was \"%s\"", claimName, claimValue));
        }
        return claimValue;
    }

    public static String validateClaimNameOverride(String name, String value) throws JwtValidatorException {
        return ClaimValidationUtils.validateString(name, value);
    }

    private static String validateString(String name, String value) throws JwtValidatorException {
        if (value == null) {
            throw new JwtValidatorException(String.format("%s value must be non-null", name));
        }
        if (value.isEmpty()) {
            throw new JwtValidatorException(String.format("%s value must be non-empty", name));
        }
        if ((value = value.trim()).isEmpty()) {
            throw new JwtValidatorException(String.format("%s value must not contain only whitespace", name));
        }
        return value;
    }
}

